<?php
$countries = App\Models\Country::with('countryCode')
->where('status','active')
->orderBy('iso_code', 'asc')
->get();
?>

<select name="<?php echo e($name); ?>" id="<?php echo e($id); ?>" class="<?php echo e($class); ?>" style="width:100%" <?php if(isset($multiple)): ?><?php echo e($multiple ? 'multiple' : ''); ?><?php endif; ?>>
    <option value=""><?php echo e($placeholder); ?></option>
    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    <?php if(isset($multiple)): ?>
    <option value="<?php echo e($country->iso_code); ?>" <?php echo e(in_array($country->iso_code, $selected) ? 'selected' : ''); ?>>
        <?php $__currentLoopData = $country->countryCode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo e($country_name['country_name']); ?> <br>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </option>
    <?php else: ?>
    <option value="<?php echo e($country->iso_code); ?>" <?php echo e($country->iso_code == $selected ? 'selected' : ''); ?>>
        <?php $__currentLoopData = $country->countryCode; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country_name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php echo e($country_name['country_name']); ?> <br>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </option>
    <?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
<script src="<?php echo e(URL::asset('assets/plugins/jquery/jquery.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $('#<?php echo e($id); ?>').select2({
        ajax: {
            url: '/get-country-name',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term,
                    page: params.page || 1,
                    "_token": '<?php echo e(csrf_token()); ?>'
                };
            },
            processResults: function(data) {
                // console.log(data);
                var mappedData = $.map(data, function(country) {
                    return {
                        id: country.iso_code,
                        text: country.cname
                    };
                });

                return {
                    results: mappedData,
                    pagination: {
                        more: mappedData.length >= 10
                    }
                };
            },
            cache: true
        }
    });

    $('#<?php echo e($id); ?>').on('change', function() {
        var country_code = $(this).val();

        $('#city_code').empty();
        $('#state_code').empty();

        if ($(this).valid()) {
            $(this).removeClass('is-invalid');
            $(this).next('.invalid-feedback').remove();
        }

        if (country_code) {
            $('#state_code').select2({
                ajax: {
                    url: '/get-state-name/' + country_code,
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            term: params.term,
                            page: params.page || 1,
                            "_token": '<?php echo e(csrf_token()); ?>'
                        };
                    },
                    processResults: function(data) {
                        var mappedData = $.map(data, function(state) {
                            return {
                                id: state.id,
                                text: state.sname
                            };
                        });

                        return {
                            results: mappedData,
                            pagination: {
                                more: mappedData.length >= 10
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Select state',
            });
            $('#city_code').select2({
                ajax: {
                    url: '/get-city-name/' + country_code,
                    dataType: 'json',
                    delay: 250,
                    data: function(params) {
                        return {
                            term: params.term,
                            page: params.page || 1,
                            "_token": '<?php echo e(csrf_token()); ?>'
                        };
                    },
                    processResults: function(data) {
                        var mappedData = $.map(data, function(city) {
                            return {
                                id: city.iso_code,
                                text: city.cname
                            };
                        });

                        return {
                            results: mappedData,
                            pagination: {
                                more: mappedData.length >= 10
                            }
                        };
                    },
                    cache: true
                },
                placeholder: 'Select city',
            });
        };
    });
</script>
<?php /**PATH C:\xampp\htdocs\Rehlte-11\resources\views/components/country_city_select.blade.php ENDPATH**/ ?>