


<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<link href="
https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css
" rel="stylesheet">

<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<style>
    .form-item input.is-valids+label {
        font-size: 11px;
        top: -5px;
    }

    .set-width {
        height: 43px !important;
        width: 230px !important;
    }

    .input-container {
        display: -ms-flexbox;/ IE10 / display: flex;
        width: 100%;
        margin-bottom: 15px;
    }

    .icon {
        padding: 10px;
        background: #ebe1e1;
        color: black;
        min-width: 25px;
        text-align: center;
        font-weight: 600
    }

    .input-field {
        width: 100%;
        padding: 10px;
        outline: none;
    }

    .input-field:focus {
        border: 2px solid dodgerblue;
    }
</style>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">General Settings</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('admin.dashboard')); ?>">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="#">General Settings</a></li>
                </ol>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->


<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 pt-3 px-3 w-100">
                <form id="settingsForm" action="#" class="form row pt-3 mb-0 validate" enctype="multipart/form-data" method="post">
                    <?php echo method_field('PUT'); ?>
                    <?php echo csrf_field(); ?>
                    <div class="row">
                        <!-- Sidebar -->
                        <div class="col-md-3">
                            <div class="list-group" style="position: sticky; top:60px;">
                                <a href="#loyalty-settings" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="background-color:#FF0000 !important; color: white !important">
                                    <i class="fas fa-coins me-2"></i> Loyalty Points Settings
                                </a>
                                <a href="#invoice-settings" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="background-color: #335476 !important; color: white !important">
                                    <i class="fa fa-file-invoice me-2"></i> Invoice Settings
                                </a>
                                <a href="#site-settings" class="list-group-item list-group-item-action" data-bs-toggle="list" onclick="this.style.backgroundColor='red'; this.style.color='white'; var siblings = this.parentElement.children; for(var i=0; i < siblings.length; i++) { if(siblings[i] !== this) { siblings[i].style.backgroundColor=''; siblings[i].style.color='white'; }}" style="background-color: #335476 !important; color: white !important">
                                    <i class="fas fa-cogs me-2"></i> Site Settings
                                </a>

                            </div>
                        </div>

                        <!-- Tab Content -->
                        <div class="col-md-9">
                            <div class="tab-content">

                                <div class="tab-pane fade show active" id="loyalty-settings">
                                    <input type="text" name="save_type" id="" value="loyalty-settings">
                                    <input type="text" name="id" id="" value="<?php echo e($loyalty_settings->id ?? ''); ?>">
                                    <div class="col-md-12 mb-4">
                                        <h5 class="m-0 text-center text-dark" style="color:black !important">Loyalty Points Settings</h5>
                                    </div>
                                    <div class="form-check d-flex align-items-center gap-2">
                                        <label class="form-check-label me-2" for="loyalty-point" style="color:black; white-space: nowrap;">
                                            Loyalty Point Expiry Date:
                                        </label>

                                        
                                        <select name="expiry_year" id="expiry_year" class="form-select" style="width: auto;">
                                            <option value="">Select Year</option>
                                            <?php for($i = 1; $i <=10; $i++): ?>
                                                <option value="<?php echo e($i); ?>" <?php if(($loyalty_settings->expiry_year ?? 0) == $i): ?> selected <?php endif; ?>><?php echo e($i); ?> Year</option>
                                                <?php endfor; ?>
                                        </select>

                                        
                                        <select name="expiry_month" id="expiry_month" class="form-select" style="width: auto;">
                                            <option value="">Select Month</option>
                                            <?php for($m = 1; $m <= 12; $m++): ?>
                                                <option value="<?php echo e($m); ?>" <?php if(($loyalty_settings->expiry_month ?? 0) == $m): ?> selected <?php endif; ?>><?php echo e($m); ?> Month</option>
                                                <?php endfor; ?>
                                        </select>

                                        
                                        <select name="expiry_day" id="expiry_day" class="form-select" style="width: auto;">
                                            <option value="">Select Day</option>
                                            <?php for($d = 1; $d <= 31; $d++): ?>
                                                <option value="<?php echo e($d); ?>" <?php if(($loyalty_settings->expiry_day ?? 0) == $d): ?> selected <?php endif; ?>><?php echo e($d); ?> Day</option>
                                                <?php endfor; ?>
                                        </select>

                                    </div>
                                    <div class="form-check d-flex align-items-center gap-2 my-4">
                                        <label class="form-check-label me-2" for="point_to_sar" style="color:black; white-space: nowrap;">
                                            Loyalty Point to Amount:
                                        </label>
                                        <div class="form-item form-float-style input-container">
                                            <i class="icon" aria-hidden="true" style="width: 54px !important;height: 41px !important;">1 SAR</i>
                                            <input class="set-width is-valid" type="text" value="<?php echo e($loyalty_settings->point_to_amount ?? 0); ?>" id="point_to_amount" name="point_to_amount" autocomplete="off" placeholder="200" required>
                                            <label for="point_to_amount" style="left: 59px !important;">point <span class="req-star">*</span></label>
                                            <i class="icon" aria-hidden="true" style="width: 38px !important;height: 41px!important;">Points</i>
                                        </div>
                                    </div>
                                    <span class="text-danger">Note: This expiry date is applied after the customer has used the service. Loyalty points remain valid until the specified expiry date.</span>
                                    <br><br>
                                    <div class="row ">
                                        <div class="col ">
                                            <button type="button" class="btn btn-primary update-btn">Save Changes</button>
                                        </div>

                                    </div>

                                </div>

                                <!-- Invoice Settings -->

                                <div class="tab-pane fade" id="invoice-settings">
                                    <input type="text" name="save_type" id="" value="invoice-settings">
                                    <input type="text" name="id" id="" value="<?php echo e($invoice_settings->id ?? ''); ?>">
                                    <div class="col-md-12 mb-4">
                                        <h5 class="m-0 text-center text-dark" style="color:black !important">Header Information</h5>
                                    </div>
                                    <div class="col-md-12 row mb-2">

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="title_en" type="text" id="title_en"
                                                    value="<?php echo e($invoice_settings->title_en ?? ''); ?>">

                                                <label for="title_en">Title (English) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="title_ar" type="text" id="title_ar"
                                                    value="<?php echo e($invoice_settings->title_ar ?? ''); ?>" dir="rtl">

                                                <label for="title_ar">Title (Arabic) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="address_en" type="text" id="address_en"
                                                    value="<?php echo e($invoice_settings->address_en ?? ''); ?>">

                                                <label for="address_en">Address (English) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="address_ar" type="text" id="address_ar"
                                                    value="<?php echo e($invoice_settings->address_ar ?? ''); ?>" dir="rtl">

                                                <label for="address_ar">Address (Arabic) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="city_en" type="text" id="city_en"
                                                    value="<?php echo e($invoice_settings->city_en ?? ''); ?>">

                                                <label for="city_en">City (English) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="city_ar" type="text" id="city_ar"
                                                    value="<?php echo e($invoice_settings->city_ar ?? ''); ?>" dir="rtl">

                                                <label for="city_ar">City (Arabic) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="country_en" type="text" id="country_en"
                                                    value="<?php echo e($invoice_settings->country_en ?? ''); ?>">

                                                <label for="country_en">Country (English) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="country_ar" type="text" id="country_ar"
                                                    value="<?php echo e($invoice_settings->country_ar ?? ''); ?>" dir="rtl">

                                                <label for="country_ar">Country (Arabic) <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="pincode" type="number" id="pincode"
                                                    value="<?php echo e($invoice_settings->pincode ?? ''); ?>">

                                                <label for="pincode">Pincode<span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="contact_email" type="email" id="contact_email"
                                                    value="<?php echo e($invoice_settings->email ?? ''); ?>">

                                                <label for="contact_email">Contact Email <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>


                                        <div class="col-md-8 mb-3">
                                            <div class="form-item form-float-style">
                                                <div class="d-flex gap-2 align-items-start">
                                                    <!-- Phone code dropdown -->
                                                    <select name="phone_code" id="phone_code" class="form-select" style="max-width: 100px; height:50px">
                                                        <option value="+966" <?php echo e(($invoice_settings->phone_code ?? '') == '+966' ? 'selected' : ''); ?>>+966</option>
                                                        <option value="+971" <?php echo e(($invoice_settings->phone_code ?? '') == '+971' ? 'selected' : ''); ?>>+971</option>
                                                        <option value="+91" <?php echo e(($invoice_settings->phone_code ?? '') == '+91'  ? 'selected' : ''); ?>>+91</option>
                                                        <option value="+1" <?php echo e(($invoice_settings->phone_code ?? '') == '+1'   ? 'selected' : ''); ?>>+1</option>
                                                    </select>


                                                    <!-- Contact No input -->
                                                    <div style="flex-grow: 1; position: relative;">
                                                        <input name="phone_no" type="text" id="contact_no" value="<?php echo e($invoice_settings->phone_no ?? ''); ?>">
                                                        <label for="contact_no" style="position: absolute; top: -8px; left: 0;">Contact No <span class="text-danger"> *</span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="invoice_logo_en" type="file" id="invoice_logo_en" autocomplete="off"
                                                    value="">
                                                <?php if(!is_null($invoice_settings) && !is_null($invoice_settings->logo_en)): ?>
                                                <img src="<?php echo e(asset('storage/' . $invoice_settings->logo_en)); ?>" alt="" width="150">
                                                <?php endif; ?>


                                                <label for="invoice_logo_en">Invoice Logo (English)</label>
                                            </div>
                                        </div>
                                    

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="invoice_logo_ar" type="file" id="invoice_logo_ar" autocomplete="off"
                                                    value="">
                                                <?php if(!is_null($invoice_settings) && !is_null($invoice_settings->logo_ar)): ?>
                                                <img src="<?php echo e(asset('storage/' . $invoice_settings->logo_ar)); ?>" alt="Invoice Logo Arabic" width="150">
                                                <?php endif; ?>



                                                <label for="invoice_logo_ar">Invoice Logo (Arabic)</label>
                                            </div>
                                        </div>

                                    </div>
                                    <button type="button" class="btn btn-primary update-btn">Save Changes</button>
                                </div>

                                <!-- End of the Invoice Settings -->

                                <!-- Site Settings  -->

                                <div class="tab-pane fade" id="site-settings">
                                    <div class="col-md-12 mb-4">
                                        <h5 class="m-0 text-center text-dark" style="color:black !important">Site Settings</h5>
                                    </div>
                                    <input type="text" name="save_type" id="" value="site-settings">
                                    <input type="text" name="id" id="" value="<?php echo e($site_settings->id ?? ''); ?>">
                                    <div class="col-md-12 row mb-2">

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="site_name" type="text" id="site_name" autocomplete="off"
                                                    value="<?php echo e($site_settings->site_title ?? ''); ?>">

                                                <label for="site_name">Site Title <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>
                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="contact_email" type="email" id="contact_email" autocomplete="off"
                                                    value="<?php echo e($site_settings->contact_email ?? ''); ?>">

                                                <label for="contact_email">Contact Email <span class="text-danger"> *</span></label>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <div class="d-flex gap-2 align-items-start">
                                                    <!-- Phone code dropdown -->
                                                    <select name="phone_code" id="phone_code" class="form-select" style="max-width: 100px; height:50px">
                                                        <option value="+966" <?php echo e(($site_settings->phone_code ?? '') == '+966' ? 'selected' : ''); ?>>+966</option>
                                                        <option value="+971" <?php echo e(($site_settings->phone_code ?? '') == '+971' ? 'selected' : ''); ?>>+971</option>
                                                        <option value="+91" <?php echo e(($site_settings->phone_code ?? '') == '+91'  ? 'selected' : ''); ?>>+91</option>
                                                        <option value="+1" <?php echo e(($site_settings->phone_code ?? '') == '+1'   ? 'selected' : ''); ?>>+1</option>
                                                    </select>


                                                    <!-- Contact No input -->
                                                    <div style="flex-grow: 1; position: relative;">
                                                        <input name="phone_no" type="text" id="contact_no" autocomplete="off" value="<?php echo e($site_settings->phone_no ?? ''); ?>">
                                                        <label for="contact_no" style="position: absolute; top: -8px; left: 0;">Contact No <span class="text-danger"> *</span></label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="col-md-4 mb-3">
                                            <div class="form-item form-float-style">
                                                <input name="site_logo" type="file" id="site_logo" autocomplete="off"
                                                    value="">
                                                <?php if(!is_null($site_settings) && !is_null($site_settings->site_logo)): ?>
                                                <img src="<?php echo e(asset('storage/' . $site_settings->site_logo)); ?>" alt="" width="150">
                                                <?php endif; ?>


                                                <label for="site_logo">Site Logo</label>
                                            </div>
                                        </div>

                                    </div>
                                    <button type="button" class="btn btn-primary update-btn">Save Changes</button>
                                </div>
                                <!-- End of Site Settings  -->


                            </div>

                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>


<?php $__env->stopSection(); ?>

<?php $__env->startSection('js'); ?>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/toastr@2.1.4/toastr.min.js"></script>

<script>
    $('input[name="save_type"]').attr('readonly', true).attr('type', 'hidden');
    $('input[name="id"]').attr('readonly', true).attr('type', 'hidden');
</script>

<script>
    document.addEventListener("DOMContentLoaded", function() {
        document.querySelectorAll(".update-btn").forEach(button => {
            button.addEventListener("click", function() {
                let activeTab = this.closest(".tab-pane");
                let formData = new FormData();
                let csrfToken = document.querySelector('meta[name="csrf-token"]').getAttribute("content");
                formData.append('_token', csrfToken);


                let errors = [];
                let inputs = activeTab.querySelectorAll("input, select, textarea");

                inputs.forEach(input => {
                    let name = input.name;
                    let value = input.value.trim();



                    if (['site_name', 'contact_email', 'phone_code', 'phone_no', 'point_to_amount'].includes(name) && value === "") {
                        errors.push(`${name.replace('_', ' ')} is required.`);
                    }

                    if (name === 'point_to_amount' && value !== "") {
                        const numericValue = parseFloat(value);
                        if (isNaN(numericValue) || numericValue <= 0) {
                            errors.push("Point to Amount must be a valid positive number.");
                        }
                    }

                    // Email format validation
                    if (name === 'contact_email' && value !== "") {
                        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                        if (!emailRegex.test(value)) {
                            errors.push("Invalid email format.");
                        }
                    }
                });


                if (errors.length > 0) {
                    errors.forEach(err => toastr.error(err));
                    return; // Stop form submission
                }

                // Append inputs to formData
                inputs.forEach(input => {
                    if (input.type === "file") {
                        if (input.files.length > 0) {
                            formData.append(input.name, input.files[0]);
                        }
                    } else {
                        formData.append(input.name, input.value);
                    }
                });

                // Create and show loader
                let loader = document.createElement("div");
                loader.innerHTML = `
                    <div class="loader-overlay">
                        <div class="loader"></div>
                    </div>
                `;
                document.body.appendChild(loader);

                fetch("/save-general-settings", {
                        method: "POST",
                        body: formData,
                        headers: {
                            "X-CSRF-TOKEN": csrfToken
                        }
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.status === "success") {
                            toastr.success(data.message || 'Settings Saved Successfully');
                            window.location.reload();
                        } else {
                            toastr.error(data.message || 'Failed to save settings');
                        }
                    })
                    .catch(error => {
                        console.error("Error:", error);
                        toastr.error("Something went wrong. Please try again.");
                    })
                    .finally(() => {
                        document.querySelector(".loader-overlay").remove();
                    });
            });
        });
    });
</script>


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\booking-new\resources\views/admin/general-setting/index.blade.php ENDPATH**/ ?>