

<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/MaterialDesign-Webfont/7.4.47/css/materialdesignicons.min.css" />
<link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables-responsive/css/responsive.bootstrap4.min.css')); ?>">
<link rel="stylesheet" href="<?php echo e(asset('assets/plugins/datatables-buttons/css/buttons.bootstrap4.min.css')); ?>">

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/css/bootstrap-datepicker.min.css">
<link rel="stylesheet" type="text/css" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/css/toastr.min.css">

<!-- New Datepicker style cdn -->
<link rel="stylesheet" href="https://code.jquery.com/ui/1.14.1/themes/base/jquery-ui.css">
<link rel="stylesheet" href="/resources/demos/style.css">

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">


<link rel="stylesheet" type="text/css" href="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.css" />

<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.css" />


<style>
  input::placeholder {
    color: white !important;
    font-style: italic;
    font-size: 14px;
    opacity: 0.7;
  }

  .card-body p {
    font-size: 10px;
  }

  .pie-chart {
    width: 100px !important;
    height: 100px !important;
  }

  .dataTables_filter {
    margin-left: 10px;
    float: right;
  }

  .datatable-container {
    padding: 0 !important;
    font-size: 13px;
  }

  .dataTables_info {
    float: left;
  }

  tr:nth-of-type(even) {
    color: #212529;
  }

  div.dataTables_wrapper div.dataTables_filter,
  div.dataTables_wrapper div.dataTables_info {
    color: #000;
  }

  /*.table-bordered tr th {
  background-color: #111c43;; 
  color:white
}*/

  .table-bordered td,
  .table-bordered th {
    border: 1px solid #dee2e6;
  }

  .table-bordered {
    border: 1px solid #dee2e6;
  }

  .booking-status {
    font-weight: bold;
  }

  .booking-status.confirmed {
    color: #4CAF50;
  }

  .booking-status.pending {
    color: #1679AB;
  }

  .booking-status.cancelled,
  .booking-status.failed {
    color: #D71920;
  }

  .booking-status span {
    font-weight: normal !important;
  }

  .table> :not(caption)>*>* {
    padding: 0.4rem 0.7rem !important;
  }

  .refund-booking {
    font-weight: bold;
    text-decoration: underline !important;
  }

  .swal2-input:focus {
    color: #FFF !important;
  }

  .datepicker td,
  .datepicker th {
    height: 50px !important;
    width: 50px !important;
    border-radius: 5px !important;
  }

  .date {
    position: relative;
  }

  .sel_date {
    background: #343a40;
    color: #fff;
    border-radius: 50px;
    text-align: center;
  }

  .sel_date::placeholder {
    color: #fff;
  }

  .datepicker {
    left: auto !important;
    right: 0 !important;
  }

  .datepicker-days tr:nth-of-type(even) {
    background-color: #f5a9a4 !important;
  }

  .dark-mode .dropdown-menu {
    background-color: #fff !important;
    color: #000 !important;
  }

  .datepicker table.no-spacing {
    border-spacing: 0 !important;
    border-collapse: collapse !important;
  }

  section {
    margin-top: 2rem;
    width: 100%;
  }

  #chart-wrap {
    display: flex;
    flex-direction: row;
    height: auto;
    justify-content: center;
    margin: auto;
    max-width: 500px;
    position: relative;
    width: 100%;
  }

  .chart-tooltip {
    margin-left: 15px;
    position: absolute;
    z-index: 10;
  }

  .chart-tooltip-wrap {
    background-color: #181818;
    border-radius: 10px;
    box-shadow: 2px 2px 5px rgba(0, 0, 0, 0.3);
    display: block;
    padding: 0.875rem;
  }

  .chart-tooltip-wrap p {
    color: #fff;
    font-size: 0.875rem;
    line-height: 1.75;
    margin: 0;
  }

  @media (max-width: 479px) {
    #chart-wrap {
      flex-direction: column;
    }
  }

  svg {
    margin: auto;
  }

  svg .text {
    fill: #fff;
    font-size: 0.875rem;
    text-anchor: middle;
  }

  .legend {
    display: flex;
    flex-direction: column;
    gap: 8px;
    justify-content: center;
    margin: 2rem auto;
  }

  @media (max-width: 479px) {
    .legend {
      flex-direction: row;
      flex-wrap: wrap;
    }
  }

  .legend-group {
    align-items: center;
    display: flex;
    flex: 1;
    flex-direction: row;
    gap: 8px;
    justify-content: flex-start;
  }

  @media (max-width: 479px) {
    .legend-group {
      flex-basis: 100px;
    }
  }

  .legend-box {
    height: 20px;
    margin: 0;
    width: 20px;
  }

  .legend-label {
    margin: 0;
    color: #000;
  }

  /* Make font smaller and uniform */
  #activeCustomersTable_wrapper,
  #failedBookingTable_wrapper {
    font-size: 12px;
  }

  /* Align search and pagination nicely */
  .dataTables_wrapper .dataTables_filter,
  .dataTables_wrapper .dataTables_paginate,
  .dataTables_wrapper .dataTables_info {
    margin-bottom: 0;
    white-space: nowrap;
  }

  /* Ensure pagination doesn't wrap or overlap */
  .dataTables_wrapper .dataTables_paginate {
    overflow-x: auto;
    display: inline-block;
  }


  #activeCustomersTable_filter {
    text-align: right !important;
  }

  .dark-mode .daterangepicker .calendar-table td,
  .dark-mode .daterangepicker .calendar-table th {
    color: black;
    background-color: white;
  }

  .table-condensed tbody tr .active {
    background-color: #0088CC !important;
    color: #fff !important;
    border: 1px solid #006699;
    border-radius: 4px;
  }

  .table-condensed tbody tr .available:hover {
    background-color: #0088CC !important;
    color: #fff !important;
    border: 1px solid #006699;
    border-radius: 4px;
  }

  .dark-mode .daterangepicker .calendar-table .next span,
  .dark-mode .daterangepicker .calendar-table .prev span {
    border-color: black;
    color: black !important;
  }

  .booking-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border-radius: 10px;
    overflow: hidden;
  }

  .booking-card:hover {
    transform: translateY(-5px) scale(1.02);
    /* box-shadow: 0 12px 24px rgba(0, 0, 0, 0.15); */
  }
</style>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">



    <div class="app-wrapper">

      <!--begin::App Main-->
      <main class="app-main">
        <!--begin::App Content Header-->
        <div class="app-content-header mb-3">
          <!--begin::Container-->
          <div class="container-fluid">
            <!--begin::Row-->
            <div class="row">
              <div class="col-sm-6">
                <h4 class="mb-0" style="color: #000;">Welcome <?php echo e(auth()->user()->name ?? ''); ?> !!</h4>
              </div>
              <div class="col-sm-6">
                <ol class="breadcrumb float-sm-end">
                  <li class="breadcrumb-item"><a href="#">Home</a></li>
                  <li class="breadcrumb-item active" aria-current="page">
                    Dashboard
                  </li>
                </ol>
              </div>
            </div>
            <!--end::Row-->
          </div>
          <!--end::Container-->
        </div>
        <div class="app-content">
          <!--begin::Container-->
          <div class="container-fluid">
            <div class="row my-3 justify-content-end">
              <div class="col-md-4">
                <div id="reportrange" style="background: #fff; cursor: pointer; padding: 5px 10px; border: 1px solid #ccc; width: 100%; color:black">
                  <i class="fa fa-calendar"></i>&nbsp;
                  <span></span> <i class="fa fa-caret-down"></i>
                </div>
              </div>
            </div>



            <!-- Info boxes -->
            <div class="row">
              <div class="col-12 col-sm-6 col-md-4 booking-card" id="totalBookingCard" data-card="total" style="cursor: pointer;">

                <div class="info-box">
                  <span class="info-box-icon text-bg-primary shadow-sm d-flex align-items-center justify-content-center">
                    <span class="mdi mdi-cart-check"></span>
                  </span>
                  <div class="info-box-content w-100">
                    <span class="info-box-text">Total Bookings</span>
                    <span class="info-box-number" id="totalBookings"><?php echo e($totalBookings ?? 0); ?></span>

                    <div class="row mt-2 border-top">
                      <div class="col text-center border-end booking-section" data-section="flight">
                        <span class="info-box-text"><i class="mdi mdi-airplane text-primary"></i> Flight</span>
                        <span class="info-box-number" id="totalFlightBookings"><?php echo e($totalFlightBookings ?? 0); ?></span>
                      </div>
                      <div class="col text-center booking-section" data-section="hotel">
                        <span class="info-box-text"><span class="mdi mdi-bed-outline text-primary"></span> Hotel</span>
                        <span class="info-box-number" id="totalHotelBookings"><?php echo e($totalHotelBookings ?? 0); ?></span>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <!-- /.col -->
              <div class="col-12 col-sm-6 col-md-4 booking-card" id="confirmedCard" data-card="confirmed" style="cursor: pointer;">
                <div class="info-box">
                  <span class="info-box-icon text-bg-success shadow-sm d-flex align-items-center justify-content-center">
                    <i class="mdi mdi-check-circle-outline text-light"></i>
                  </span>
                  <div class="info-box-content w-100">
                    <span class="info-box-text">Confirmed Bookings</span>
                    <span class="info-box-number" id="totalConfirmedBookings"><?php echo e($confirmedBookings ?? 0); ?></span>

                    <div class="row mt-2 border-top">
                      <div class="col text-center border-end booking-section" data-section="flight_confirmed">
                        <span class="info-box-text"><i class="mdi mdi-airplane-check text-success"></i> Flight</span>
                        <span class="info-box-number" id="flightConfirmedBookings"><?php echo e($flightConfirmedBookings ?? 0); ?></span>
                      </div>
                      <div class="col text-center booking-section" data-section="hotel_confirmed">
                        <span class="info-box-text"><span class="mdi mdi-bed-outline text-success"></span> Hotel</span>
                        <span class="info-box-number" id="hotelConfirmedBookings"><?php echo e($hotelConfirmedBookings?? 0); ?></span>
                      </div>
                    </div>
                  </div>
                </div>
                <!-- /.info-box -->
              </div>
              <!-- /.col -->

              <div class="col-12 col-sm-6 col-md-4 booking-card" id="failedCard" data-card="failed" style="cursor: pointer;">
                <div class="info-box">
                  <span class="info-box-icon text-bg-danger shadow-sm d-flex align-items-center justify-content-center">
                    <i class="mdi mdi-close-circle-outline text-light"></i>
                  </span>
                  <div class="info-box-content w-100">
                    <span class="info-box-text">Failed Bookings</span>
                    <span class="info-box-number" id="totalFailedBookings"><?php echo e($failedBookings ?? 0); ?></span>

                    <div class="row mt-2 border-top">
                      <div class="col text-center border-end booking-section" data-section="flight_failed">
                        <span class="info-box-text"> <i class="mdi mdi-airplane text-danger"></i> Flight</span>
                        <span class="info-box-number" id="flightFailedBookings"><?php echo e($flightFailedBookings ?? 0); ?></span>
                      </div>
                      <div class="col text-center booking-section" data-section="hotel_failed">
                        <span class="info-box-text"><span class="mdi mdi-bed-outline text-danger"></span> Hotel</span>
                        <span class="info-box-number" id="hotelFailedBookings"><?php echo e($hotelFailedBookings ?? 0); ?></span>
                      </div>
                    </div>
                  </div>
                </div>

              </div>
              <!-- /.col -->
            </div>
            <!-- /.row -->

            <!--begin::Row-->
            <div class="row">
              <div class="col-md-12">
                <div class="card mb-4">
                  <div class="card-header">
                    <h5 class="card-title">Monthly Recap Report</h5>

                  </div>
                  <!-- /.card-header -->
                  <div class="card-body">
                    <!--begin::Row-->
                    <div class="row">
                      <div class="col-md-8">
                        <p class="text-center">
                          <strong>Overall Report</strong>
                        </p>

                        <div id="sales-chart"></div>
                      </div>
                      <!-- /.col -->
                      <div class="col-md-4">
                        <p class="text-center">
                          <strong>Goal Completion</strong>
                        </p>

                        <?php $__currentLoopData = $goals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $goal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $percentage = $goal['target'] > 0 ? round(($goal['current'] / $goal['target']) * 100) : 0;
                        $percentage = $percentage > 100 ? 100 : $percentage;
                        ?>
                        <div class="progress-group" style="color: #000; font-size:12px">
                          <?php echo e($goal['title']); ?>

                          <span class="float-end"><b><?php echo e($goal['current']); ?></b>/<?php echo e($goal['target']); ?></span>
                          <div class="progress progress-sm">
                            <div class="progress-bar text-bg-<?php echo e($goal['color']); ?>" style="width: <?php echo e($percentage); ?>%"></div>
                          </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>


                      <!-- /.col -->
                    </div>
                    <!--end::Row-->
                  </div>
                  <!-- ./card-body -->
                  <div class="card-footer">
                    <!--begin::Row-->
                    <div class="row">
                      <?php $__currentLoopData = $dashboardStats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <?php
                      $icon = match($stat['direction']) {
                      'up' => 'bi-caret-up-fill',
                      'down' => 'bi-caret-down-fill',
                      'left' => 'bi-caret-left-fill',
                      default => '',
                      };
                      ?>
                      <div class="col-md-3 col-6">
                        <div class="text-center <?php echo e(!$loop->last ? 'border-end' : ''); ?>">
                          <span class="text-<?php echo e($stat['color']); ?>">
                            <i class="bi <?php echo e($icon); ?>"></i>
                          </span>
                          <h6 class="fw-bold mb-0" style="color:black">
                            <?php echo e($stat['is_currency'] ? 'SAR ' . number_format($stat['value'], 2) : $stat['value']); ?>

                          </h6>
                          <span class="text-uppercase" style="color:black"><?php echo e($stat['label']); ?></span>
                        </div>
                      </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>

                    <!--end::Row-->
                  </div>
                  <!-- /.card-footer -->
                </div>
                <!-- /.card -->
              </div>
              <!-- /.col -->
            </div>
            <!--end::Row-->

            <!--begin::Row-->
            <div class="row">
              <!-- Start col -->
              <div class="col-md-8">
                <!--begin::Row-->
                <div class="row g-4 mb-4">
                  <div class="col-md-6">
                    <div class="card mb-4">
                      <div class="card-header">
                        <h3 class="card-title">Overall Statistics</h3>


                      </div>
                      <!-- /.card-header -->
                      <div class="card-body">
                        <!--begin::Row-->
                        <div class="row">
                          <div class="col-12">
                            <div id="chart-wrap"></div>
                          </div>
                          <!-- /.col -->
                        </div>
                        <!--end::Row-->
                      </div>
                      <!-- /.card-body -->
                      <!-- <div class="card-footer p-0">
                        <ul class="nav nav-pills flex-column">
                          <li class="nav-item">
                            <a href="#" class="nav-link">
                              United States of America
                              <span class="float-end text-danger">
                                <i class="bi bi-arrow-down fs-7"></i>
                                12%
                              </span>
                            </a>
                          </li>
                          <li class="nav-item">
                            <a href="#" class="nav-link">
                              India
                              <span class="float-end text-success">
                                <i class="bi bi-arrow-up fs-7"></i> 4%
                              </span>
                            </a>
                          </li>
                          <li class="nav-item">
                            <a href="#" class="nav-link">
                              China
                              <span class="float-end text-info">
                                <i class="bi bi-arrow-left fs-7"></i> 0%
                              </span>
                            </a>
                          </li>
                        </ul>
                      </div> -->
                      <!-- /.footer -->
                    </div>
                  </div>
                  <!-- /.col -->

                  <div class="col-md-6">
                    <!-- USERS LIST -->
                    <div class="card">
                      <div class="card-header">
                        <h3 class="card-title">Latest Members</h3>

                        <div class="card-tools">
                          <span class="badge text-bg-danger">
                            <?php echo e($newCustomerCount ?? 0); ?> New Customers
                          </span>

                        </div>
                      </div>
                      <!-- /.card-header -->
                      <div class="card-body p-0">
                        <div class="row text-center m-1">
                          <?php $__currentLoopData = $customers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $customer): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <div class="col-3 p-2">
                            <img
                              class="img-fluid rounded-circle"
                              src="<?php echo e(asset('assets/images/no-image.png')); ?>"
                              alt="User Image" />
                            <a
                              class="btn fw-bold fs-7 text-secondary text-truncate w-100 p-0"
                              href="#">
                              <?php echo e($customer->first_name ?? ''); ?>

                            </a>
                            <p>Today</p>
                          </div>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </div>
                        <!-- /.users-list -->
                      </div>
                      <!-- /.card-body -->
                      <div class="card-footer text-center" style="cursor: pointer;" onclick="window.location.href = '<?php echo e(url('/customers')); ?>';">
                        <a href="javascript:" class="link-primary link-offset-2 link-underline-opacity-25 link-underline-opacity-100-hover">View All Customers</a>
                      </div>
                      <!-- /.card-footer -->
                    </div>
                    <!-- /.card -->
                  </div>
                  <!-- /.col -->
                </div>
                <!--end::Row-->

                <!--begin::Latest Order Widget-->
                <div class="card">
                  <div class="card-header">
                    <h3 class="card-title">Latest Orders</h3>
                  </div>
                  <!-- /.card-header -->
                  <div class="card-body p-0">
                    <div class="table-responsive">
                      <table class="table m-0">
                        <thead>
                          <tr>
                            <th>Booking ID</th>
                            <th>Service</th>
                            <th>Booking Status</th>
                            <th>Booked At</th>

                          </tr>
                        </thead>
                        <tbody>
                          <?php $__currentLoopData = $recentBookings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $recentBooking): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                          <tr>
                            <td>
                              <a href="<?php echo e(route('booking.edit', $recentBooking->id)); ?>" title="View" class="link-primary link-offset-2 link-underline-opacity-25 link-underline-opacity-100-hover"><?php echo e($recentBooking->booking_ref); ?></a>
                            </td>
                            <td><?php echo e($recentBooking->booking_type ?? ''); ?></td>
                            <td>
                              <span class="badge <?php if($recentBooking->booking_status == 'confirmed'): ?> text-bg-success <?php elseif($recentBooking->booking_status == 'pending'): ?> text-bg-primary <?php else: ?> text-bg-danger <?php endif; ?>">
                                <?php echo e($recentBooking->booking_status ?? ''); ?>

                              </span>

                            </td>
                            <td>

                              <?php echo e($recentBooking->created_at ?? ''); ?>



                            </td>

                          </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                      </table>
                    </div>
                    <!-- /.table-responsive -->
                  </div>
                  <!-- /.card-body -->
                  <div class="card-footer clearfix">

                    <a
                      href="<?php echo e(url('/booking')); ?>"
                      class="btn btn-sm float-end" style="background-color: #335476; color:white">
                      View All Orders
                    </a>
                  </div>
                  <!-- /.card-footer -->
                </div>
                <!-- /.card -->



              </div>
              <!-- /.col -->


              <div class="col-md-4">
                <!-- Info Boxes Style 2 -->
                <div class="info-box mb-3 text-bg-warning">
                  <span class="info-box-icon">
                    <i class="fas fa-plane"></i>
                  </span>

                  <div class="info-box-content" style="cursor: pointer;" onclick="window.location.href = '<?php echo e(url('/trending-flight')); ?>';">
                    <span class="info-box-text">Trending Flights</span>
                    <span class="info-box-number"><?php echo e($trendingFlights ?? 0); ?></span>
                  </div>
                  <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
                <div class="info-box mb-3 text-bg-success">
                  <span class="info-box-icon">
                    <i class="fas fa-hotel"></i>
                  </span>

                  <div class="info-box-content" style="cursor: pointer;" onclick="window.location.href = '<?php echo e(url('/trending-hotel')); ?>';">
                    <span class="info-box-text">Trending Hotels</span>
                    <span class="info-box-number"><?php echo e($trendingHotels ?? 0); ?></span>
                  </div>
                  <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
                <div class="info-box mb-3 text-bg-danger">
                  <span class="info-box-icon">
                    <i class="fas fa-plane"></i> <i class="fas fa-chart-line text-success"></i>

                  </span>

                  <div class="info-box-content" style="cursor: pointer;" onclick="window.location.href = '<?php echo e(url('/seo-trending-flight')); ?>';">
                    <span class="info-box-text">SEO Trending Flights</span>
                    <span class="info-box-number"><?php echo e($seoTrendingFlights ?? 0); ?></span>
                  </div>
                  <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->
                <div class="info-box mb-3 text-bg-info" style="cursor: pointer;" onclick="window.location.href = '<?php echo e(url('/seo-trending-hotel')); ?>';">
                  <span class="info-box-icon">
                    <i class="fas fa-hotel"></i> <i class="fas fa-chart-line text-success"></i>

                  </span>

                  <div class="info-box-content">
                    <span class="info-box-text">SEO Trending Hotels</span>
                    <span class="info-box-number"><?php echo e($seoTrendingHotels ?? 0); ?></span>
                  </div>
                  <!-- /.info-box-content -->
                </div>
                <!-- /.info-box -->


                <!-- /.card -->

                <!-- PRODUCT LIST -->
                <div class="card">
                  <div class="card-header">
                    <h3 class="card-title">User Login Activities</h3>

                  </div>
                  <div class="card-body p-0">
                    <div class="px-2">
                      <?php $__currentLoopData = $userLogin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $login): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                      <div class="d-flex border-top py-2 px-1">

                        <div class="col-12">
                          <a href="javascript:void(0)" class="fw-bold" style="font-size: 14px;">
                            <?php echo e($login->email ?? ''); ?>

                            <span class="badge text-bg-warning float-end">
                              <?php echo e($login->created_at ? $login->created_at->format('F d, Y h:i A') : ''); ?>


                            </span>
                          </a>

                        </div>
                      </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </div>
                  </div>

                  <div class="card-footer text-center">
                    <a href="javascript:void(0)" class="uppercase">

                    </a>
                  </div>
                  <!-- /.card-footer -->
                </div>


                <!-- /.card -->
              </div>
              <!-- /.col -->


            </div>
            <!--end::Row-->
          </div>
          <!--end::Container-->
          <div class="row">
            <div class="col">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title mb-0">Active Customers</h3>
                </div>

                <div class="card-body p-0">
                  <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0" id="activeCustomersTable">
                      <thead class="thead-light">
                        <tr>
                          <th scope="col">S.No</th>
                          <th scope="col">Name</th>
                          <th scope="col">Email</th>
                          <th scope="col">Device ID</th>
                          <th scope="col">Request</th>
                          <th scope="col">Browser Name</th>
                          <th scope="col">Created At</th>

                        </tr>
                      </thead>
                      <tbody>
                        <!-- Dynamic content via DataTables -->
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>

            </div>
            <div class="col">
              <div class="card">
                <div class="card-header">
                  <h3 class="card-title mb-0">Failed Bookings</h3>
                </div>

                <div class="card-body p-0">
                  <div class="table-responsive">
                    <table class="table table-striped table-hover mb-0" id="failedBookingTable">
                      <thead class="thead-light">
                        <tr>
                          <th scope="col">S.No</th>
                          <th scope="col">Booking Ref</th>
                          <th scope="col">Service</th>
                          <th scope="col">Status</th>
                          <th scope="col">Created At</th>

                        </tr>
                      </thead>
                      <tbody>
                        <!-- Dynamic content via DataTables -->
                      </tbody>
                    </table>
                  </div>
                </div>
              </div>

            </div>
          </div>


          <div class="container card" style="display:none">
            <div class="card-header">
              <h3 class="card-title">Reports</h3>

              <div class="card-tools">
                <button
                  type="button"
                  class="btn btn-tool"
                  data-lte-toggle="card-collapse">
                  <i data-lte-icon="expand" class="bi bi-plus-lg"></i>
                  <i data-lte-icon="collapse" class="bi bi-dash-lg"></i>
                </button>
                <button
                  type="button"
                  class="btn btn-tool"
                  data-lte-toggle="card-remove">
                  <i class="bi bi-x-lg"></i>
                </button>
              </div>
            </div>
            <div class="row card-body" style="background-color: white;">
              <div class=" col-md-4 p-3 " style="border: 1px solid lightblue;">
                <canvas id="customersChart"></canvas>
              </div>
              <div class="col-md-4 p-3" style="border: 1px solid lightblue;">
                <canvas id="bookingChart"></canvas>
              </div>
              <div class="col-md-4 p-3" style="border: 1px solid lightblue;">
                <canvas id="couponChart"></canvas>
              </div>
            </div>


          </div>
          <!--end::App Content-->
      </main>
      <!--end::App Main-->

    </div>


  </div> <!-- End of container-fluid -->
</div> <!-- End of content-header -->

<!-- /.content-header -->

<!-- Main content -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>



<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script src="<?php echo e(asset('assets/plugins/datatables/jquery.dataTables.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-responsive/js/dataTables.responsive.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-responsive/js/responsive.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/dataTables.buttons.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.bootstrap4.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/pdfmake/pdfmake.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/pdfmake/vfs_fonts.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.html5.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.print.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/plugins/datatables-buttons/js/buttons.colVis.min.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap-datepicker@1.9.0/dist/js/bootstrap-datepicker.min.js"></script>


<!-- New Jcdn for Datepicker -->
<script src="https://code.jquery.com/ui/1.14.1/jquery-ui.js"></script>

<script src="https://cdnjs.cloudflare.com/ajax/libs/d3/7.8.5/d3.min.js"></script>
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/js/toastr.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/momentjs/latest/moment.min.js"></script>
<script type="text/javascript" src="https://cdn.jsdelivr.net/npm/daterangepicker/daterangepicker.min.js"></script>
<script type="text/javascript">
  $(document).ready(function() {

    // Chart for Total Customes
    const customerLabels = <?php echo json_encode($customerLabels, 15, 512) ?>;
    const customerData = <?php echo json_encode($customerData, 15, 512) ?>;

    // Initialize Chart.js
    const ctx_customer = document.getElementById('customersChart').getContext('2d');
    const gradient_customer = ctx_customer.createLinearGradient(0, 0, 0, 400);
    gradient_customer.addColorStop(0, 'rgba(75, 192, 192, 1)');
    gradient_customer.addColorStop(1, 'rgba(153, 102, 255, 1)');


    new Chart(ctx_customer, {
      type: 'bar',
      data: {
        labels: customerLabels,
        datasets: [{
          label: 'Total Customers',
          data: customerData,
          backgroundColor: gradient_customer,
          borderColor: 'rgb(17, 28, 66)',
          borderWidth: 1,
          borderRadius: 10,
          barThickness: 30,
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
            labels: {
              font: {
                family: 'Roboto',
                size: 14,
                weight: 'bold'
              },
              color: '#181818',
            }
          },
          tooltip: {
            backgroundColor: '#ffffff',
            titleColor: '#333',
            bodyColor: '#333',
            titleFont: {
              family: 'Roboto',
              size: 14,
              weight: 'bold'
            },
            bodyFont: {
              family: 'Roboto',
              size: 12
            },
            borderColor: 'rgba(0,0,0,0.1)',
            borderWidth: 1
          }
        },
        scales: {
          x: {
            ticks: {
              color: '#333',
              font: {
                family: 'Roboto',
                size: 12
              }
            },
            grid: {
              display: false
            }
          },
          y: {
            beginAtZero: true,
            ticks: {
              color: '#333',
              font: {
                family: 'Roboto',
                size: 12
              }
            },
            grid: {
              color: 'rgba(200, 200, 200, 0.2)',
              borderDash: [5, 5]
            }
          }
        }
      }
    });

    // Chart for Bookings

    const bookingLabels = <?php echo json_encode($bookingLabels, 15, 512) ?>;
    const bookingData = <?php echo json_encode($bookingData, 15, 512) ?>;

    // Initialize Chart.js
    const ctx_booking = document.getElementById('bookingChart').getContext('2d');
    const gradient_booking = ctx_booking.createLinearGradient(0, 0, 0, 400);
    gradient_booking.addColorStop(0, 'rgba(75, 192, 192, 1)');
    gradient_booking.addColorStop(1, 'rgba(153, 102, 255, 1)');

    new Chart(ctx_booking, {
      type: 'bar',
      data: {
        labels: bookingLabels,
        datasets: [{
          label: 'Total Bookings',
          data: bookingData,
          backgroundColor: gradient_booking,
          borderColor: 'rgb(17, 28, 66)',
          borderWidth: 1,
          borderRadius: 10,
          barThickness: 30,
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
            labels: {
              font: {
                family: 'Roboto',
                size: 14,
                weight: 'bold'
              },
              color: '#181818',
            }
          },
          tooltip: {
            backgroundColor: '#ffffff',
            titleColor: '#333',
            bodyColor: '#333',
            titleFont: {
              family: 'Roboto',
              size: 14,
              weight: 'bold'
            },
            bodyFont: {
              family: 'Roboto',
              size: 12
            },
            borderColor: 'rgba(0,0,0,0.1)',
            borderWidth: 1
          }
        },
        scales: {
          x: {
            ticks: {
              color: '#333',
              font: {
                family: 'Roboto',
                size: 12
              }
            },
            grid: {
              display: false
            }
          },
          y: {
            beginAtZero: true,
            ticks: {
              color: '#333',
              font: {
                family: 'Roboto',
                size: 12
              }
            },
            grid: {
              color: 'rgba(200, 200, 200, 0.2)',
              borderDash: [5, 5]
            }
          }
        }
      }
    });



    // Chart for Coupons
    const couponLabels = <?php echo json_encode($couponLabels, 15, 512) ?>;
    const couponData = <?php echo json_encode($couponData, 15, 512) ?>;

    // Gradient Colors
    const ctx_coupon = document.getElementById('couponChart').getContext('2d');
    const gradient_coupon = ctx_coupon.createLinearGradient(0, 0, 0, 400);
    gradient_coupon.addColorStop(0, 'rgba(75, 192, 192, 1)');
    gradient_coupon.addColorStop(1, 'rgba(153, 102, 255, 1)');

    // Initialize Chart.js
    new Chart(ctx_coupon, {
      type: 'bar',
      data: {
        labels: couponLabels,
        datasets: [{
          label: 'Total Coupons',
          data: couponData,
          backgroundColor: gradient_coupon,
          borderColor: 'rgb(17, 28, 66)',
          borderWidth: 1,
          borderRadius: 10, // Rounded corners for bars
          barThickness: 30, // Adjust bar thickness
        }]
      },
      options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
          legend: {
            labels: {
              font: {
                family: 'Roboto',
                size: 14,
                weight: 'bold'
              },
              color: '#181818',
            }
          },
          tooltip: {
            backgroundColor: '#ffffff',
            titleColor: '#333',
            bodyColor: '#333',
            titleFont: {
              family: 'Roboto',
              size: 14,
              weight: 'bold'
            },
            bodyFont: {
              family: 'Roboto',
              size: 12
            },
            borderColor: 'rgba(0,0,0,0.1)',
            borderWidth: 1
          }
        },
        scales: {
          x: {
            ticks: {
              color: '#333',
              font: {
                family: 'Roboto',
                size: 12
              }
            },
            grid: {
              display: false
            }
          },
          y: {
            beginAtZero: true,
            ticks: {
              color: '#333',
              font: {
                family: 'Roboto',
                size: 12
              }
            },
            grid: {
              color: 'rgba(200, 200, 200, 0.2)',
              borderDash: [5, 5]
            }
          }
        }
      }
    });






    const pieChartData = <?php echo json_encode($bookings, 15, 512) ?>;

    const wrap = d3.select('#chart-wrap');
    let wrapWidth = parseInt(wrap.style('width'));

    const colorsArray = ['#5626C4', '#E60576', '#2CCCC3', '#FACD3D', '#FF5100'];
    const formatPerc = d3.format(".0%");
    let width, height, pieRadius, total, arc;

    const tooltipMouseMove = (d) => {
      const xArc = arc.centroid(d)[0] + (width / 2);
      const yArc = arc.centroid(d)[1] + (height / 2);

      tooltipChart
        .html(() => {
          return (
            `<div class="chart-tooltip-wrap">
                    <p>Percentage: ${formatPerc(d.value / total)}</p>
                    <p>Value: ${d.value}</p>
                </div>`
          );
        })
        .style('visibility', 'visible')
        .style('top', 0)
        .style('left', 0)
        .style("transform", `translate(${xArc + 80}px, ${yArc - 25}px)`);
    };

    const tooltipMouseOut = () => {
      tooltipChart.style('visibility', 'hidden');
    };

    // Responsive dimensions
    if (wrapWidth <= 479) {
      width = 250;
      height = 250;
    } else {
      width = 300;
      height = 300;
    }

    pieRadius = Math.min(width / 2, height / 2);

    const pie = d3.pie().value((d) => d.value);

    arc = d3.arc().outerRadius(pieRadius).innerRadius(0);

    const svg = wrap.append('svg').attr('width', width).attr('height', height);

    svg.append('title').attr('id', 'chart-title').html('Pie chart');
    svg.append('desc').attr('id', 'chart-desc').html('Displays booking data.');

    svg.attr('aria-labelledby', 'chart-title chart-desc');

    const tooltipChart = wrap.append('div').attr('class', 'chart-tooltip').style('visibility', 'hidden');

    const g = svg.append('g')
      .attr('width', width)
      .attr('height', height)
      .style('transform', `translate(${width / 2}px, ${height / 2}px)`);

    const legend = wrap.append('div').attr('class', 'legend');

    function createPie(data) {
      total = d3.sum(data, (d) => d.value);

      // Create pie slices
      g.selectAll('.arc')
        .data(pie(data))
        .enter()
        .append('path')
        .attr('class', 'slices')
        .attr('fill', (d, i) => colorsArray[i])
        .on('mouseover', (event, d) => tooltipMouseMove(d))
        .on('mouseout', tooltipMouseOut)
        .transition()
        .duration(1000)
        .attrTween('d', (f) => {
          f.innerRadius = 0;
          const interp = d3.interpolate({
            startAngle: 0,
            endAngle: 0
          }, f);
          return (t) => arc(interp(t));
        });

      // Add percentage labels
      g.selectAll('.text')
        .data(pie(data))
        .enter()
        .append('text')
        .attr('transform', (d) => `translate(${arc.centroid(d)})`)
        .attr('class', 'text')
        .style('opacity', '0')
        .text((d) => formatPerc(d.value / total))
        .transition()
        .duration(300)
        .style('opacity', '1');

      // Add legend
      legend.selectAll('div')
        .data(data)
        .enter()
        .append('div')
        .attr('class', 'legend-group')
        .html((d, i) => `
            <div class="legend-box" style="background-color: ${colorsArray[i]};"></div>
            <p class="legend-label">${d.name}</p>
        `);
    }

    // Pass Laravel data to createPie
    createPie(pieChartData);
  });
</script>



<script
  src="https://cdn.jsdelivr.net/npm/apexcharts@3.37.1/dist/apexcharts.min.js"
  integrity="sha256-+vh8GkaU7C9/wbSLIcwq82tQ2wTf44aOHA8HlBMwRI8="
  crossorigin="anonymous"></script>


<script>
  const customerLabels = <?php echo json_encode($customerLabels, 15, 512) ?>;
  const customerData = <?php echo json_encode($customerData, 15, 512) ?>;

  const bookingLabels = <?php echo json_encode($bookingLabels, 15, 512) ?>;
  const bookingData = <?php echo json_encode($bookingData, 15, 512) ?>;

  const couponLabels = <?php echo json_encode($couponLabels, 15, 512) ?>;
  const couponData = <?php echo json_encode($couponData, 15, 512) ?>;

  const sales_chart_options = {
    series: [{
        name: "Customers",
        data: customerData,
      },
      {
        name: "Bookings",
        data: bookingData,
      },
      {
        name: "Coupons",
        data: couponData,
      },
    ],
    chart: {
      height: 180,
      type: "area",
      toolbar: {
        show: false,
      },
    },
    legend: {
      show: true,
    },
    colors: ["#0d6efd", "#20c997", "#ffc107"],
    dataLabels: {
      enabled: false,
    },
    stroke: {
      curve: "smooth",
    },
    xaxis: {
      type: "category",
      categories: customerLabels,
    },
    tooltip: {
      x: {
        format: "MMMM",
      },
    },
  };

  const sales_chart = new ApexCharts(
    document.querySelector("#sales-chart"),
    sales_chart_options
  );
  sales_chart.render();
</script>

<script>
  $(document).ready(function() {

    $('#activeCustomersTable').DataTable({
      processing: true,
      serverSide: true,
      ajax: {
        url: '<?php echo e(route("active.customers")); ?>',
        type: "GET"
      },
      columns: [{
          data: 'DT_RowIndex',
          name: 'DT_RowIndex',
          orderable: false,
          searchable: false
        },
        {
          data: 'name',
          name: 'customer.first_name'
        },
        {
          data: 'email',
          name: 'customer.email'
        },
        {
          data: 'device_id',
          name: 'device_id'
        },
        {
          data: 'request_url',
          name: 'request_url'
        },
        {
          data: 'browser_name',
          name: 'browser_name'
        },
        {
          data: 'created_at',
          name: 'created_at'
        }
      ],
      responsive: true,
      autoWidth: false,
      order: [
        [5, 'desc']
      ],
      pageLength: 10
    });


    // Failed Bookings Table
    $('#failedBookingTable').DataTable({
      processing: true,
      serverSide: true,
      ajax: '<?php echo e(route("failed.bookings")); ?>',
      columns: [{
          data: 'DT_RowIndex',
          name: 'DT_RowIndex',
          orderable: false,
          searchable: false
        },
        {
          data: 'booking_ref',
          name: 'booking_ref'
        },
        {
          data: 'booking_type',
          name: 'booking_type'
        },
        {
          data: 'booking_status',
          name: 'booking_status'
        },
        {
          data: 'created_at',
          name: 'created_at'
        }
      ],
      responsive: true,
      autoWidth: false,
      order: [
        [1, 'asc']
      ],
      pageLength: 10,

    });

    var start = moment();
    var end = moment();

    // Function to fetch dashboard stats via AJAX
    function fetchFilteredData(from, to) {
      let formData = {
        filter: 'custom',
        from_date: from.format('YYYY-MM-DD'),
        to_date: to.format('YYYY-MM-DD'),
        _token: "<?php echo e(csrf_token()); ?>"
      };

      $.ajax({
        url: "<?php echo e(route('dashboard.filter')); ?>",
        method: 'POST',
        data: formData,
        beforeSend: function() {
          $("#spinner").show();
        },
        success: function(response) {
          $('#totalBookings').text(response.totalBookings);
          $('#totalFlightBookings').text(response.totalFlightBookings);
          $('#totalHotelBookings').text(response.totalHotelBookings);
          $('#totalConfirmedBookings').text(response.totalConfirmedBookings);
          $('#totalFailedBookings').text(response.totalFailedBookings);
          $('#flightConfirmedBookings').text(response.flightConfirmedBookings);
          $('#flightFailedBookings').text(response.flightFailedBookings);
          $('#hotelConfirmedBookings').text(response.hotelConfirmedBookings);
          $('#hotelFailedBookings').text(response.hotelFailedBookings);
        },
        complete: function() {
          $("#spinner").hide();
        },
        error: function() {
          alert("Something went wrong. Please try again.");
        }
      });
    }


    function updateBookingCardLinks(start, end) {
      const from = start.format('YYYY-MM-DD');
      const to = end.format('YYYY-MM-DD');
      const baseUrl = `<?php echo e(url('/booking')); ?>`;

      const urls = {
        total: {
          default: `${baseUrl}?from=${from}&to=${to}`,
          flight: `${baseUrl}?from=${from}&to=${to}&type=flight`,
          hotel: `${baseUrl}?from=${from}&to=${to}&type=hotel`
        },
        confirmed: {
          default: `${baseUrl}?from=${from}&to=${to}&booking_status=confirmed`,
          flight: `${baseUrl}?from=${from}&to=${to}&type=flight&booking_status=confirmed`,
          hotel: `${baseUrl}?from=${from}&to=${to}&type=hotel&booking_status=confirmed`
        },
        failed: {
          default: `${baseUrl}?from=${from}&to=${to}&booking_status=failed`,
          flight: `${baseUrl}?from=${from}&to=${to}&type=flight&booking_status=failed`,
          hotel: `${baseUrl}?from=${from}&to=${to}&type=hotel&booking_status=failed`
        }
      };

      $('.booking-card').on('click', function(e) {
        const cardType = $(this).data('card');
        const section = $(e.target).closest('.booking-section').data('section');

        let key = 'default';
        if (section?.includes('flight')) key = 'flight';
        if (section?.includes('hotel')) key = 'hotel';

        const targetUrl = urls[cardType][key];
        if (targetUrl) {
          window.location.href = targetUrl;
        }
      });





    }

    // Callback function for datepicker
    function cb(start, end) {
      $('#reportrange span').html(start.format('MMMM D, YYYY') + ' - ' + end.format('MMMM D, YYYY'));
      fetchFilteredData(start, end);
      updateBookingCardLinks(start, end);
    }

    // Initialize daterangepicker
    $('#reportrange').daterangepicker({
      startDate: start,
      endDate: end,
      ranges: {
        'Today': [moment(), moment()],
        'Yesterday': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
        'Last 7 Days': [moment().subtract(6, 'days'), moment()],
        'Last 30 Days': [moment().subtract(29, 'days'), moment()],
        'This Month': [moment().startOf('month'), moment().endOf('month')],
        'Last Month': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
      },
      locale: {
        applyLabel: "Apply",
        cancelLabel: "Cancel",
        daysOfWeek: ["Su", "Mo", "Tu", "We", "Th", "Fr", "Sa"],
        monthNames: [
          "January", "February", "March", "April", "May", "June",
          "July", "August", "September", "October", "November", "December"
        ],
        firstDay: 0
      }
    }, cb);

    // Trigger initial load
    cb(start, end);
  });
</script>




<?php $__env->appendSection(); ?>
<?php echo $__env->make('admin.layout.main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\booking-new\resources\views/admin/dashboard/dashboard.blade.php ENDPATH**/ ?>