
<?php $__env->startSection('title', @trans('login.title')); ?>
<style>
    .swal2-close:focus {
        box-shadow: none !important;
    }

    /* Spinner Container */
    #loadingSpinner {
        display: none;
        position: fixed;
        top: 0;
        left: 0;
        width: 100%;
        height: 100%;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 9999;
        color: #EE3137;
    }

    /* Spinner Centering */
    #loadingSpinner .overlay {
        position: absolute;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
    }

    /* Spinner Size */
    .spinner-border {
        width: 4.5rem;
        height: 4rem;
        border-width: 5px;
    }
</style>
<?php $__env->startSection('content'); ?>
<div class="bg-clr">
    <?php if(session('success')): ?>
    <div class="alert alert-success" role="alert">
        <?php echo session('success'); ?>
    </div>
    <?php endif; ?>
    <?php if(session('error')): ?>
    <div class="alert alert-danger" role="alert">
        <?php echo e(session('error')); ?>

    </div>
    <?php endif; ?>
    <?php if(isset($error)): ?>
    <div class="alert alert-danger" role="alert">
        <?php echo e($error); ?>

    </div>
    <?php endif; ?>
    <div class="logo-login">
        <?php
        @$logo = App\Models\Setting::where('config_key', 'general|basic|colorLogo')->get('value')[0]['value'];
        @$value = App\Models\Setting::where('config_key', 'general|basic|siteName')->get('value')[0]['value'];
        ?>
        <a href="<?php echo e(route('admin.login')); ?>">
            <?php if($logo): ?>
            <!-- <img src="<?php echo e(@$logo); ?>" alt=""> -->
            <img src="<?php echo e(URL::asset('assets/images/rehtle_logo.png')); ?>" alt="">
            <?php elseif($value): ?>
            <h1><?php echo e($value); ?></h1>
            <?php else: ?>
            <img src="<?php echo e(URL::asset('assets/images/rehtle_logo.png')); ?>" alt="">
            <?php endif; ?>
        </a>
    </div>
    <h2><?php echo app('translator')->get('login.loginHeading'); ?></h2>
    <!-- Loading Spinner -->
    <div id="loadingSpinner">
        <div class="overlay">
            <div class="spinner-border" role="status" style="color: #EE3137;">
                <span class="visually-hidden">Loading...</span>
            </div>
        </div>
    </div>
    <form action="<?php echo e(route('verifyLogin')); ?>" method="post" class="form row mx-0 validate" name="loginForm" id="loginForm">
        <?php echo csrf_field(); ?>


        <!--Errors variable used from form validation -->
        <?php if($errors->any()): ?>
        <div class="alert alert-light text-danger">
            <ul>
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li class="text-red"><?php echo e($error); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
        </div>
        <?php endif; ?>



        <div class="login-page p-0">
            <div class="form-item form-float-style form-group">
                <input type="text" id="login_mobileno" class="is-valid" name="mobile" autocomplete="off" required>
                <label for="login_mobileno">Email Address</label>
            </div>
            <div class="form-item form-float-style form-group position-relative">
                <input type="password" id="login_password" class="is-valid" name="password" autocomplete="off" required>
                <label for="login_password"><?php echo app('translator')->get('login.password'); ?></label>
                <span class="toggle-password" onclick="togglePasswordVisibility()" style="position: absolute; top: 50%; right: 10px; transform: translateY(-50%); cursor: pointer;">
                    <i id="toggleIcon" class="fa fa-eye"></i>
                </span>
            </div>

            <div class="g-recaptcha mt-4" data-sitekey=<?php echo e(config('services.recaptcha.key')); ?>></div>
            <!-- <div class="form-check filter-check sub-check mt-2">
                <input class="form-check-input" type="checkbox" id="flexCheckDefault1">
                <label class="form-check-label" for="flexCheckDefault1">
                    <?php echo app('translator')->get('login.rememberMe'); ?>
                </label>
            </div> -->
        </div>

        <div class="login-bottom">
            <button type="submit" class="btn login-btn"><?php echo app('translator')->get('login.login'); ?></button>
            <!-- <a href="<?php echo e(route('admin.forgot-password')); ?>" type="submit" class="btn forgot-btn"><?php echo app('translator')->get('login.forgotPassword'); ?></a> -->
        </div>
    </form>

</div>

<script>
    document.getElementById('loginForm').addEventListener('submit', function() {
        // Show the loading spinner
        document.getElementById('loadingSpinner').style.display = 'block';
    });
</script>
<script>
    $(function() {
        $.validator.addMethod("email_regex", function(value, element, regexpr) {
            return this.optional(element) || regexpr.test(value);
        }, "Please enter a valid Email Address.");

        $('#loginForm').validate({
            rules: {
                mobile: {
                    required: true,
                    email: true,
                    email_regex: /\b[A-Z0-9._%+-]+@[A-Z0-9.-]+\.[A-Z]{2,4}\b/i

                },
                password: {
                    required: true,
                },
            },
            messages: {
                mobile: {
                    required: "Please enter an Email Address",
                },
                password: {
                    required: "Please enter a Password"
                },
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            }
        });
    });
</script>
<script>
    function togglePasswordVisibility() {
        const passwordInput = document.getElementById('login_password');
        const toggleIcon = document.getElementById('toggleIcon');

        if (passwordInput.type === 'password') {
            passwordInput.type = 'text';
            toggleIcon.classList.remove('fa-eye');
            toggleIcon.classList.add('fa-eye-slash');
        } else {
            passwordInput.type = 'password';
            toggleIcon.classList.remove('fa-eye-slash');
            toggleIcon.classList.add('fa-eye');
        }
    }
</script>

<script async src="https://www.google.com/recaptcha/api.js"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layout.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\booking-new\resources\views/admin/auth/login.blade.php ENDPATH**/ ?>