<?php


use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;
use App\Http\Controllers\API\V1\CoreController;
use App\Http\Controllers\API\V1\PageController;
use App\Http\Controllers\API\V1\HotelController;
use App\Http\Controllers\API\V1\FlightController;
use App\Http\Controllers\API\V1\BookingController;
use App\Http\Controllers\API\V1\PaymentController;
use App\Http\Controllers\API\V1\CustomerController;
use App\Http\Controllers\Admin\Auth\LoginController;
use App\Http\Controllers\API\V1\BestOfferController;
use App\Http\Controllers\API\V1\ContactUsController;
use App\Http\Controllers\API\V1\GeographyController;
use App\Http\Controllers\API\V1\GoogleMapController;
use App\Http\Controllers\API\V1\SubscribeController;
use App\Http\Controllers\API\V1\TravellerController;
use App\Http\Controllers\API\V1\AuthGeneralController;
use App\Http\Controllers\API\V1\SummerOfferController;
use App\Http\Controllers\API\V1\FeatureHotelController;
use App\Http\Controllers\Admin\BookingController as AdminBookingController;
use App\Http\Controllers\API\V1\ImageProxyController;

Route::domain(env('APP_API_URL'))
    ->prefix('v1')
    ->group(function () {

        Route::get('clear-cache', function () {
            Artisan::call('optimize:clear');
            return "Cleared!";
        });

        // Auth Api User Login
        Route::post('api-login', [AuthGeneralController::class, 'ApiUserLogin']);
        Route::get('check-token-validity', [AuthGeneralController::class, 'checkTokenValidity']);

        Route::get('home-data', [PageController::class, 'getHomeData']);

        Route::get('app-qr-code-links', [PageController::class, 'getAppQrCodeLinks']);


        Route::group(['middleware' => ['auth:appuser-api']], function () {
            Route::get('refresh-token', [AuthGeneralController::class, 'refreshToken']);

            // Delete User Account API
            Route::post('get-deleteAccount-otp', [AuthGeneralController::class, 'deleteAccountRequest']);
            Route::post('delete-account', [AuthGeneralController::class, 'deleteAccount']);
        });


        Route::controller(HotelController::class)->prefix('hotel')->group(function () {
            Route::post('hotels-by-city', 'hotelSearch');
            Route::post('hotel-search-by-city', 'hotelSearchByCity');
            Route::post('hotel-details', 'hotelDetail');
            Route::post('hotel-details-by-hotel-code', 'hotelDetailsByHotelCode');
            Route::post('hotel-availability', 'hotelAvailability');

            Route::post('hotels-by-city-geo', 'getHotelsByGeo');
            Route::post('hotels-by-filters', 'getHotelsByFilters');
            Route::post('hotels-by-ids', 'getHotelsByIds');
            Route::post('hotel-details-by-id', 'getHotelDetailsById');
            Route::post('room-cancellation-policy', 'getRoomCancellationPolicy');

            // Favorites APIs

            Route::post('add-favourites', 'add_favourites');
            Route::post('get-last-booking', 'get_LastBooking');
            Route::post('get-favourites', 'get_favourites');
            Route::post('delete-favourites', 'delete_favourites');

            // Wallet APIs

            Route::post('wallet-details-by-id', 'getWalletDetails');

            // Get Map and Street for Hotel List Page
            Route::post('get-hotel-list-map', 'getHotelListMap');

            // Get Hotel Description and Facilities
            Route::post('get-hotel-facilities', 'getGimmonixHotelFacilities');

            // Get Updated Hotel Price
            Route::post('get-updated-hotel-price', 'getUpdatedHotelPrice');

            // Get Around this Hotel Details
            Route::post('get-around-this-hotel', 'getAroundThisHotel');

            Route::post('hotels-by-city-geo-encrypt', 'getEncryptHotelsByGeo');
            Route::get('hotel-images/{any}', [ImageProxyController::class, 'hotelImage'])->where('any', '.*');

            Route::get('get-hotel-special-request', 'getHotelSpecialRequest');
        });

        Route::controller(PaymentController::class)->prefix('payment')->group(function () {
            Route::post('create-reference', 'createReference');
            Route::post('add-hotel-guest-info', 'addHotelGuestInfo');
            Route::post('update-reference', 'updateReference');
            Route::post('get-reference', 'getReference');
            Route::post('apply-coupon', 'applyCoupon');
            Route::post('book-add-ons', 'bookAddOns');
            Route::post('get-checkout-id', 'getCheckoutId');
            Route::post('get-checkout-ids', 'getCheckoutIds');
            Route::post('apply-redeem-points', 'applyRedeemPoints');
            Route::post('apply-wallet-balance', 'applyWalletBalance');
            // Route::post('test', 'PaymentController@test');
        });


        Route::group(['middleware' => ['auth:appuser-api']], function () {
            Route::post('test', [PaymentController::class, 'test']);
        });


        // Auth General API
        Route::post('login', [AuthGeneralController::class, 'login']);
        Route::post('signup', [AuthGeneralController::class, 'signup']);

        Route::post('check-user-exists', [AuthGeneralController::class, 'checkUserExists']);

        // Google Map API
        Route::post('google-place-search', [GoogleMapController::class, 'placeSearch']);
        Route::post('google-detail-place-search', [GoogleMapController::class, 'placeDetailSearch']);
        Route::post('geo-location-by-ip', [GoogleMapController::class, 'geoLocationByIp']);

        // Core API
        Route::controller(CoreController::class)->prefix('core')->group(function () {
            Route::get('getGeneral', 'getGeneralDetails');
            Route::get('currencies', 'getCurrenciesDetails');
            Route::get('featured-flight', 'getFeatureFlightDetails');
            Route::get('languages', 'getLanguageDetails');
            Route::get('language-translate', 'getLanguageTranslateDetails');
            Route::get('service-types', 'getServiceTypeDetails');
            Route::get('maintenance-mode', 'checkMaintenance');

            //fetch home banner data
            Route::get('get-home-banner', 'getHomeBanners');
            Route::get('get-arabic-speak-countries', 'getArabicSpeakCountries');
        });

        Route::controller(CustomerController::class)->prefix('customer')->group(function () {
            Route::post('customer-login', 'login');
            Route::post('customer-signup', 'signUpCustomer');
            Route::post('verification-otp/send', 'otpVerificationSend');
            Route::post('verification-otp/verify', 'OtpVerify');
            Route::post('forgot-password-otp/send', 'forgotPassword');
            Route::post('forgot-password-otp/verify', 'forgotPasswordOtpVerify');
            Route::group(['middleware' => ['auth:appuser-api']], function () {
                Route::post('resend-activation-mail', 'customerResendMail');
                Route::get('get-customer-profile', 'customerProfile');
                Route::post('update-customer', 'updateCustomer');
                Route::post('update-customer-image', 'updateCustomerImage');
                Route::delete('delete-customer', 'deleteCustomer');
                Route::post('update-customer-data', 'updateCustomerData');
                // Modified

                // Route::post('update-customer-data', 'CustomerController@updateCustomer');
                Route::get('wallet-list', 'getWalletList');
                Route::get('coupon-list', 'getCouponList');
                Route::post('favorite-hotel', 'handleFavoriteHotel');
                Route::get('dashboard-data', 'dashboardData');
                Route::post('reset-password', 'resetForgotPassword');
                Route::post('change-password', 'changePassword');
                Route::post('close-account', 'closeAccount');
                Route::post('logout-customer', 'logout');
            });
            Route::post('verify-customer-mobile', 'verifyCustomerwithMobile');

            // Google Sign In Using email (For Mobile App)
            Route::post('mobile-google-sign-in', 'googleSignInWithEmail');
        });

        // Traveller API


        Route::middleware(['auth:appuser-api'])->group(function () {
            Route::controller(TravellerController::class)->group(function () {
                Route::get('get-traveller-list', 'getTraveller');
                Route::post('create-traveller', 'TcreateTraveller');
                Route::post('update-traveller', 'updateTraveller');
                Route::delete('delete-traveller/{traveller_id}', 'destroy');
            });

            Route::controller(BookingController::class)->group(function () {
                Route::get('rehlte-points', 'getCustomerRehltePoints');
                Route::get('rehlte-points-history', 'getCustomerRehltePointsHistory');
            });
        });





        Route::controller(FlightController::class)->prefix('flight')->group(function () {
            Route::get('search/airport', 'airportSearch');
            Route::get('search', 'flightSearch');
            Route::get('flight-dashboard', 'flightDashboard');

            Route::post('flight-offers', 'flightSearch');
            Route::post('flight-offers-search', 'flightOffersSearch');
            Route::post('flight-calendar-search', 'flightCalendarSearch');
            Route::post('flight-offers-bags', 'flightOfferPriceWithBags');
            Route::post('flight-offers-price', 'flightOfferPrice');
            Route::post('flight-offers-price-with-markup', 'flightOfferPriceWithMarkup');
            Route::post('flight-offers-price-upselling', 'flightOfferPriceUpselling');
            Route::post('flight-offers-seatmap-amenities', 'flightOfferPriceAmenities');
            Route::post('flight-offers-seatmap-amenities-by-booking', 'flightOfferPriceAmenitiesByBooking');
            Route::get('get-airlines', 'getAirlines');
            Route::post('flight-order-create', 'flightOrderCreate');
            // Temporarily store data while make checkout
            Route::get('get-stored-reference', 'getStoredReference');

            // Price Details Request
            Route::post('get-farebasis-details', 'getFareBasisDetails');

            // Testing
            Route::post('get-updated-flight-price', 'getUpdatedFlightPrice');

            // Get Lowest Price
            Route::post('get-lowest-flight-price', 'getLowestFlightPrice');

            Route::get('/export-airports', 'exportAllAirportsJson');
            Route::get('/get-airport-json', 'getAllAirportsJson');
        });

        Route::prefix('flight')->group(function () {
            Route::get('feature-hotels', [FeatureHotelController::class, 'getFeatureHotels']);
            Route::post('feature-hotels', [FeatureHotelController::class, 'createFeatureHotel']);
            Route::put('feature-hotels', [FeatureHotelController::class, 'updateFeatureHotel']);
            Route::delete('feature-hotels/{id}', [FeatureHotelController::class, 'deleteFeatureHotel']);

            Route::get('best-offers', [BestOfferController::class, 'getBestOffers']);
            Route::post('best-offers', [BestOfferController::class, 'createBestOffer']);
            Route::put('best-offers', [BestOfferController::class, 'updateBestOffer']);
            Route::delete('best-offers/{id}', [BestOfferController::class, 'deleteBestOffer']);

            Route::get('summer-offers', [SummerOfferController::class, 'getSummerOffers']);
            Route::post('summer-offers', [SummerOfferController::class, 'createSummerOffer']);
            Route::put('summer-offers', [SummerOfferController::class, 'updateSummerOffer']);
            Route::delete('summer-offers/{id}', [SummerOfferController::class, 'deleteSummerOffer']);
        });

        Route::controller(PageController::class)->prefix('page')->group(function () {
            Route::get('get-pages', 'getpages');
            Route::get('page-code', 'getPageCodeDetails');
            Route::get('coupondetail', 'getCouponDetail');
        });

        Route::controller(GeographyController::class)->prefix('geography')->group(function () {
            Route::get('get-countries', 'getCountries');
            Route::get('get-country', 'getCountryDetails');
            Route::get('get-states', 'getStateDetails');
            Route::get('get-cities', 'getCityDetails');
            Route::post('get-cities-details', 'getCitiesDetails');
            Route::get('get-city-list', 'getCityList');

            Route::get('get-top-destination-countries', 'getTopDestinationCountries');
            Route::get('get-top-destination-cities', 'getTopDestinationCities');

            Route::get('export-countries-json', 'exportAllCountriesJson');
            Route::get('get-countries-json', 'getAllCountriesJson');
        });

        Route::controller(BookingController::class)->prefix('booking')->group(function () {
            /**
             * Deprecated routes starts here 
            Route::post('create-booking', 'createBooking');
            Route::post('checkout-booking', 'getCheckoutDetails');
            Route::post('get-checkout-details', 'getCheckoutDetails');
            Route::post('get-hotel-checkout-details', 'getHotelCheckoutDetails');
            Route::post('get-updated-checkout-details', 'getUpdatedCheckoutDetails');
            Route::get('process-booking', 'processBooking');
            Route::post('process-booking', 'processBooking');
            Route::get('process-booking2', 'processBooking2');
            Route::post('process-booking2', 'processBooking2');          
            Route::get('web-hook', 'webHook');
            Route::post('web-hook', 'webHook');
            Route::post('create-flight-booking', 'createFlightBooking');
            Route::post('send-test-sms', 'sendTestSms');
             * Deprecated routes ends here 
             **/

            Route::get('get-booking-status', 'getBookingStatus');
            Route::get('get-booking', 'getBooking');
            Route::post('validate-booking', 'validateBooking');
            Route::post('validate-flight-booking', 'validateBooking');
            Route::post('resend-email-booking-details', 'resendEmailBookingDetails');
            Route::group(['middleware' => ['auth:appuser-api']], function () {
                Route::get('get-bookings', 'getBookings');
                Route::get('get-flight-bookings', 'getBookings');
                Route::post('loyalty-points', 'getBookingLoyaltyPoints');
            });
            Route::get('process-booking-payment', 'processBookingPayment');
            Route::post('process-booking-payment', 'processBookingPayment');
            Route::get('check-booking-exist', 'checkBookingExist');

            Route::post('payment-status-by-payment-id', 'getPaymentStatusByPaymentId');
            Route::post('booking-status-by-ref-id', 'getBookingStatusByRefId');
        });

        Route::controller(AdminBookingController::class)->prefix('booking')->group(function () {
            // Download Ticket ,Voucher and Invoice    
            Route::get('/{id}/{locale?}', 'downloadTicket')->name('booking.show');
            Route::get('/show_invoice/{id}/{locale?}', 'show_invoice')->name('admin.booking.show_invoice');

            Route::get('/download-flight-ticket/{id}/{locale?}', 'downloadFlightTicket')->name('admin.booking.download-flight-ticket');
            Route::get('/showFlightTicket/{id}/{locale?}', 'showFlightTicket')->name('admin.booking.showFlightTicket');

            Route::get('/downloadInvoice/{id}/{locale?}', 'downloadInvoice')->name('admin.booking.show_invoice');
            Route::get('/downloadVoucher/{id}/{locale?}', 'downloadVocher')->name('admin.booking.downloadVoucher');
            Route::get('/show_voucher/{id}/{locale?}', 'show')->name('admin.booking.show_voucher');
        });


        Route::controller(LoginController::class)->group(function () {
            Route::post('social-login', 'socialLogin');
            Route::post('auth/google', 'googleSignIn');
            Route::post('auth/facebook', 'facebookSignIn');
        });

        // Trending Search in Frontent API

        Route::post('get-trending-search', [HotelController::class, 'getTrendingSearchDetails']);
        // Route::get('auth/facebook',  [LoginController::class,'redirectToFacebook']);
        // Route::get('auth/facebook/callback', [LoginController::class,'handleFacebookCallback']);

        Route::post('subscribe', [SubscribeController::class, 'addEmail']);

        Route::post('checkmarkup', [FlightController::class, 'checkMarkupRule']);
        Route::post('contact-us', [ContactUsController::class, 'store']);


        Route::get('get-qr-url', [PageController::class, 'generateQrUrl']);


        // Update City Latitude

        // Route::get('/update-latitude',[GeographyController::class,'updateCityLatitude']);

        Route::get('hotel-recommendation', [HotelController::class, 'getHotelRecommendations']);

        // Route::post('test-whatsapp',[BookingController::class, 'testWhatsapp']);
        Route::get('delete-booking-checkout', [BookingController::class, 'deleteBookingCheckout']);
        Route::get('delete-supplier-log', [BookingController::class, 'deleteSupplierLog']);

        // Route::get('proxy-image/{any}', [ImageProxyController::class, 'serve'])->where('any', '.*');
         Route::get('qr-redirect/{code?}', [PageController::class, 'handleQrRedirect']);


        Route::group(['middleware' => 'authenticate_api_key'], function () {
            Route::get('get-key', [CoreController::class, 'getAPIKeys'])->withoutMiddleware(['encrypt.data']);
        });
    });
