@extends('admin.layout.main')
@section('title', $header['title'])

@section('content')

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 align-items-center d-flex breadcrumb-style">
                <h1 class="m-0">{{ $header['heading'] }}</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('adminUser.dashboard') </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('wallet.index') }}">Wallets</a></li>
                    <li class="breadcrumb-item active">{{ $header['breadcrumb'] }}</li>
                </ol>
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 w-100 px-3 py-2">
                <form class="form row mb-0 pt-3 validate" action="{{ isset($wallet) ? route('wallet.update', $wallet->id) : route('wallet.store') }}"
                    enctype="multipart/form-data" method="post" id="dataForm" name="dataForm">
                    @csrf
                    @if(isset($wallet))
                    @method('PUT')
                    @endif

                    <div class="col-md-6">
                        <div class="select top-space-rem after-drp form-item form-float-style">
                            <select data-live-search="true" id="wallet_customer" required name="customer" class="order-td-input selectpicker select-text height_drp is-valid">
                                <option value="">Select customer</option>
                                @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ isset($wallet) && $wallet->customer_id == $customer->id ? 'selected' : '' }}>
                                    {{ $customer->email }}
                                </option>
                                @endforeach
                            </select>
                            <label for="Select Status">Select customer<span class="req-star">*</span></label>
                            @error('customer')
                            <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>


                    <div class="col-md-6">
                        <div class="select top-space-rem after-drp form-item form-float-style">
                            <select data-live-search="true" id="booking_id" required name="booking_id" class="order-td-input selectpicker select-text height_drp is-valid">
                                <option value="">Select booking</option>
                                @foreach($bookings as $booking)
                                <option value="{{ $booking->id }}" {{ isset($wallet) && $wallet->booking_id == $booking->id ? 'selected' : '' }}>
                                    {{ $booking->booking_ref }} - {{ $booking->booking_type }}
                                </option>
                                @endforeach
                            </select>
                            <label for="Select Status">Select booking<span class="req-star">*</span></label>
                            @error('booking_id')
                            <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="form-item form-float-style form-group">
                            <input type="number" name="balance" required id="balance" autocomplete="off" class="is-valid"
                                value="{{ old('balance', isset($wallet) ? $wallet->balance : '') }}">
                            <label for="email">Wallet Amount <span class="req-star">*</span></label>
                            @error('balance')
                            <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-item form-float-style form-group">
                            <input type="text" name="wallet_currency" required id="wallet_currency" autocomplete="off" class="is-valid"
                                value="{{ old('wallet_currency', $wallet->currency ?? '') }}">
                            <label for="wallet_currency">Currency <span class="req-star">*</span></label>
                            <span style="font-size:12px ;color:red">* Currency Should be SAR/USD</span>
                            @error('wallet_currency')
                            <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>



                    <div class="col-md-6">
                        <div class="form-item form-float-style form-group">
                            <label for="attachment">Attachment (Image)</label>
                            <input type="file" name="attachment" id="attachment" class="" accept="image/*">
                            @error('attachment')
                            <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>

                        @isset($wallet->attachment)
                        <img src="{{ asset('storage/' . $wallet->attachment) }}" alt="Attachment" width="100">
                        @endisset



                    </div>


                    <div class="col-md-6">
                        <div class="select top-space-rem after-drp form-item form-float-style">
                            <select data-live-search="true" id="status" required name="status" class="order-td-input selectpicker select-text height_drp is-valid">
                                <option value="">Select status</option>
                                <option value="active" {{ isset($wallet) && $wallet->status == 'active' ? 'selected' : '' }}>Active</option>
                                <option value="inactive" {{ isset($wallet) && $wallet->status == 'inactive' ? 'selected' : '' }}>Inactive</option>
                            </select>
                            <label for="Select Status">Select Status<span class="req-star">*</span></label>
                            @error('status')
                            <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="select top-space-rem after-drp form-item form-float-style">
                            <input type="date" name="expiry_date" required id="expiry_date" autocomplete="off" class="datepicker is-valids is-valid" value="{{ isset($wallet) && $wallet->expiry_date  ? $wallet->expiry_date  : '' }}">
                            <label for="Select Status">Expiry Date<span class="req-star">*</span></label>
                            @error('status')
                            <span class="invalid-feedback d-block">{{ $message }}</span>
                            @enderror
                        </div>
                    </div>

                    <div class="cards-btn">
                        <button type="submit" id="disBtn" class="btn btn-success form-btn-success">
                            @lang('adminUser.submit')
                        </button>
                        <a href="{{ route('wallet.index') }}" class="btn btn-danger form-btn-danger">
                            @lang('adminUser.cancel')
                        </a>
                    </div>
                </form>



            </div>
            <!-- /.row -->
        </div>
        <!--/. container-fluid -->
</section>
@endsection
@section('js')


<script>
    $(document).ready(function() {
        // Listen for change on the customer dropdown
        $('#wallet_customer').change(function() {
            var customerId = $(this).val();

            const base_url = `${window.location.origin}`;

            const send_url = base_url + '/bookings/' + customerId;

            console.log(send_url);

            if (customerId) {
                $.ajax({
                    url: base_url + '/bookings/' + customerId,
                    method: 'GET',
                    success: function(data) {
                        $('#booking_id').empty();

                        $.each(data, function(index, booking) {
                            $('#booking_id').append('<option value="' + booking.id + '">' + booking.booking_ref + ' - ' + booking.booking_type + '</option>');
                        });

                        $('#booking_id').selectpicker('refresh');
                    },
                    error: function(xhr, status, error) {
                        alert('Error fetching bookings');
                    }
                });
            } else {
                $('#booking_id').empty();
                $('#booking_id').append('<option value="">Select booking</option>');
                $('#booking_id').selectpicker('refresh');
            }
        });

        $('#booking_id').change(function() {
            var booking_id = $(this).val();
            const base_url = window.location.origin;

            if (booking_id) {
                $.ajax({
                    url: base_url + '/wallet/get-wallet-currency/' + booking_id,
                    method: 'GET',
                    success: function(data) {
                        if (data.status) {
                            $('#wallet_currency').val(data.currency);
                        } else {
                            alert(data.message || 'Failed to fetch currency');
                        }
                    },
                    error: function(xhr) {
                        alert('Server error');
                        console.error(xhr.responseText);
                    }
                });
            }
        });



    });



    // Listen for file input change event

    $('.select-validate').on('change', function() {
        if ($(this).valid()) {
            // If the file is valid, remove the 'is-invalid' class
            $(this).removeClass('is-invalid');
            // Remove the 'invalid-feedback' element
            $(this).next('.invalid-feedback').remove();
        }
    });
    $("#isd_code").change(function() {
        var choice = jQuery(this).val();
        //if you just want to remove them all
        $("#isd_code-error").remove();

        if ($(this).val() == '') {
            $('#isd_code-error').show();
        } else {
            $('#isd_code-error').hide();
        }

    });

    $(function() {




        $('*[value=""]').removeClass('is-valid');


        $('#dataForm').validate({
            rules: {
                wallet_customer: {
                    required: true
                },
                booking_id: {
                    required: true
                },
                balance: {
                    required: true,
                    digits: true
                },
                status: {
                    required: true
                }

            },
            messages: {
                wallet_customer: {
                    required: "Please chosse Customer",
                },
                booking_id: {
                    required: "Please chosse Booking",
                },
                balance: {
                    required: "Please enter a Mobile Number",
                    minlength: "Please enter valid Wallet amount",
                },
                status: {
                    required: "Plese enter an Email Address"
                }
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function(form) {
                $("#disBtn").attr("disabled", true);
                form.submit();
            }
        });

    });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>
<style>
    .isd_code-error {
        display: none;
        width: 100%;
        margin-top: 0.25rem;
        font-size: .875em;
        color: #dc3545;
    }
</style>
@append