@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
  .form-item input.is-valids+label {
    font-size: 11px;
    top: -5px;
  }

  .hidden {
    display: none;
  }
  .dark-mode .select2-container .select2-search--inline .select2-search__field {
    color: #222 !important;
  }
  .select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: #222 !important;
    padding-left: 25px !important;
  }
</style>


<!-- /.Start content-header -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-4 mt-2">
      <div class="col-sm-12 d-flex breadcrumb-style">
        <h1 class="m-0">Tour Codes - Add</h1>
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
          <li class="breadcrumb-item"><a href="{{ route('tour-code.index') }}">Tour Codes</a></li>
          <li class="breadcrumb-item active">Add</li>
        </ol>
      </div><!-- /.col -->

    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
  <!-- Start container fluid -->
  <div class="container-fluid">
    <!-- Start Row Div -->
    <div class="row">
      <form id="basicForm" class="form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('tour-code.store') }}" method="post" enctype="multipart/form-data">
        <div class="card pb-4 pt-4 px-3 w-100">

          <div class="col-md-12">
            <div class="form-group">
              @if (session('success'))
              <div class="alert alert-success" role="alert">
                <?php echo session('success'); ?>
              </div>
              @endif
              @if (session('error'))
              <div class="alert alert-danger" role="alert">
                {{ session('error') }}
              </div>
              @endif
              @if (isset($error))
              <div class="alert alert-danger" role="alert">
                {{ $error }}
              </div>
              @endif
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-12 discount">
              @csrf
              <div class="form-item form-float-style form-group">
                <input type="text" value="" id="tour_code" name="tour_code" autocomplete="off" class="is-valid">
                <label for="tour_code">Tour Code <span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <select data-live-search="true" id="from_airport" name="from_airports[]" class="order-td-input select-text height_drp is-valid select2 airport_list" multiple style="width: 100%;" placeholder="Select Airport">
                    <?php
                    if (count($airports) > 0) {
                        foreach ($airports as $iataCode => $airportName) {
                            echo '<option value="' . $iataCode . '">'. $airportName . '</option>';
                        }
                    }
                    ?>
                </select>
                <label for="from_airport">From Airport(s)<span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <select data-live-search="true" id="to_airport" name="to_airports[]" class="order-td-input select-text height_drp is-valid select2 airport_list" multiple style="width: 100%;" placeholder="Select Airport">
                    <?php
                    if (count($airports) > 0) {
                        foreach ($airports as $iataCode => $airportName) {
                            echo '<option value="' . $iataCode . '">'. $airportName . '</option>';
                        }
                    }
                    ?>
                </select>
                <label for="to_airport">To Airport(s)<span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <input type="text" value="" id="from_date" name="from_date" autocomplete="off" class="is-valid">
                <label for="from_date">From Date<span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <input type="text" value="" id="to_date" name="to_date" autocomplete="off" class="is-valid">
                <label for="to_date">To Date <span class="req-star">*</span></label>
              </div>
              <div class="form-floating form-float-style form-group required mb-3">
                <div class="form-item form-float-style serach-rem mb-3">
                  <div class="select top-space-rem after-drp form-float-style form-group">
                    <select data-live-search="true" name="status" id="status" class="order-td-input selectpicker select-text height_drp is-valid select-validate">
                      <option value="" selected>Select Status</option>
                      <option value="1">Active</option>
                      <option value="0">In-active</option>
                    </select>
                    <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">@lang('adminUser.status') <span class="text-red">*</span></label>
                  </div>
                </div>
              </div>


            </div><!-- End general information div-->







            <div class="col-md-6 discount">
              <div class="cards-btn">
                <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>
                <a href="{{ route('tour-code.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
              </div>

            </div>
      </form>

    </div>
  </div>
  </div>
  </div>
  </div>
  </div>



  </div>
  <!-- /.row -->
  </div>
  <!-- End Row Div -->

  </div>

  <!-- End container fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
    $(document).ready(function() {
        const dateToday = new Date();
        $("#from_date").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#to_date").datepicker("option", "minDate", selected);
                $(this).valid();
            }
        });
        $("#to_date").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                //$("#from_date").datepicker("option", "maxDate", selected);
                $(this).valid();
            }
        });
        $('.airport_list').select2();
    });
</script>

@append
