@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
    .form-item input.is-valids+label {
        font-size: 11px;
        top: -5px;
    }

    .hidden {
        display: none;
    }

    .dark-mode .select2-container .select2-search--inline .select2-search__field {
        color: #222 !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #222 !important;
        padding-left: 25px !important;
    }

    input[readonly] {
        cursor: not-allowed;
    }
</style>


<!-- /.Start content-header -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">Popular Travels Destinations - View</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('popular-travel.index') }}">Popular Travels Destinations</a></li>
                    <li class="breadcrumb-item active">View</li>
                </ol>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
    <!-- Start container fluid -->
    <div class="container-fluid">
        <!-- Start Row Div -->
        <div class="row">

            <div class="card pb-4 pt-4 px-3 w-100">




                <div class="row mb-3">

                    <h5 style="color:black;">Popular Travel Destinations</h5>
                    <hr style="color:black;"><br>
                    <table class="table table-borderd">
                        <tbody>
                            <tr>
                                <td style="color:black; font-weight:bold">Name: </td>
                                <td style="color:black;">{{$popularTravelDetails->name }}</td>
                            </tr>
                            <tr>
                                <td style="color:black; font-weight:bold">URL: </td>
                                <td style="color:black;"> <a href="{{$popularTravelDetails->url}}" target="_blank">{{$popularTravelDetails->url}}</a> </td>
                            </tr>

                            <tr>
                                <td style="color:black; font-weight:bold">Price</td>
                                <td style="color:black;">{{$popularTravelDetails->price}} SAR</td>
                            </tr>


                            <tr>
                                <td style="color:black; font-weight:bold">Thumbnail</td>
                                <td style="color:black;"> <img src="{{ asset('storage/' . $popularTravelDetails->thumbnail) }}" alt="Travel Destination" width="100px"> </td>
                            </tr>

                            <tr>
                                <td style="color:black; font-weight:bold">Status: </td>
                                <td style="color:black;">{{$popularTravelDetails->status == 1 ? 'Active' : 'Inactive' }}</td>
                            </tr>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
    </div>
    </div>



    </div>
    <!-- /.row -->
    </div>
    <!-- End Row Div -->

    </div>

    <!-- End container fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
    $(document).ready(function() {
        $('.airport_list').select2();
    });
</script>

@append