@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
  .form-item input.is-valids+label {
    font-size: 11px;
    top: -5px;
  }

  .hidden {
    display: none;
  }

  .dark-mode .select2-container .select2-search--inline .select2-search__field {
    color: #222 !important;
  }

  .select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: #222 !important;
    padding-left: 25px !important;
  }
</style>


<!-- /.Start content-header -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-4 mt-2">
      <div class="col-sm-12 d-flex breadcrumb-style">
        <h1 class="m-0">Popular Travel Destinations - Add</h1>
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
          <li class="breadcrumb-item"><a href="{{ route('popular-travel.index') }}">Popular Travel Destinations</a></li>
          <li class="breadcrumb-item active">Add</li>
        </ol>
      </div><!-- /.col -->

    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
  <!-- Start container fluid -->
  <div class="container-fluid">
    <!-- Start Row Div -->
    <div class="row">
      <form id="basicForm" class="form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('popular-travel.store') }}" method="post" enctype="multipart/form-data">
        <div class="card pb-4 pt-4 px-3 w-100">

          <div class="col-md-12">
            <div class="form-group">
              @if (session('success'))
              <div class="alert alert-success" role="alert">
                <?php echo session('success'); ?>
              </div>
              @endif
              @if (session('error'))
              <div class="alert alert-danger" role="alert">
                {{ session('error') }}
              </div>
              @endif
              @if (isset($error))
              <div class="alert alert-danger" role="alert">
                {{ $error }}
              </div>
              @endif
            </div>
          </div>

          <div class="row mb-3">
            @csrf
            <div class="col-md-6">
              <div class="form-item form-float-style form-group">
                <input name="name" type="text" id="name" autocomplete="off" value="" required>

                <label for="from_airport">Name<span class="req-star">*</span></label>
              </div>
            </div>
            <div class="col-md-6">
              <div class="form-item form-float-style form-group">
                <input name="popular_url" type="url" id="url" autocomplete="off" value="" required>
                <label for="to_airport">URL<span class="req-star">*</span></label>
              </div>
            </div>


            <div class="col-md-6">
              <div class="form-item form-float-style form-group">
                <input name="travel_thumbnail" type="file" id="thumbnail" autocomplete="off" value="" required>
                <label for="thumbnail">Thumbnail<span class="req-star">*</span></label>
              </div>
            </div>


            <div class="col-md-6">
              <div class="form-item form-float-style form-group">
                <input name="travel_price" type="number" id="travel_price" autocomplete="off" value="" required>
                <label for="travel_price">Price<span class="req-star">*</span></label>
              </div>
            </div>






            <div class="col-md-6">
              <div class="form-item form-float-style">
                @php
                $countries = App\Models\Country::with('countryCode')
                ->where('status', 'active')
                ->orderBy('iso_code', 'asc')
                ->get();
                @endphp
                <select name="country_code" id="country_code" data-live-search="true" class="order-td-input selectpicker1 select-text height_drp is-valid select2" style="width:100%" onchange="getCity(this.value)">
                  <option value="">Select Country</option>
                  @foreach($countries as $country)
                  <option value="{{ $country->iso_code }}">
                    @foreach($country->countryCode as $country_name)
                    {{ $country_name['country_name'] }} <br>
                    @endforeach
                  </option>
                  @endforeach
                </select>
                <label for="code">Select Country <span class="req-star">*</span></label>
              </div>
            </div>


            <div class="col-md-6">
              <div class="form-item form-float-style">
                <select data-live-search="true" name="city" id="city" class="order-td-input selectpicker1 select-text height_drp is-valid select2 city-select" style="width: 100%" required></select>
                <label>Select City <span class="req-star">*</span></label>
              </div>
            </div>


            <div class="col-md-6">
              <div class="form-floating form-float-style form-group required mb-3">
                <div class="form-item form-float-style serach-rem mb-3">
                  <div class="select top-space-rem after-drp form-float-style form-group">
                    <select data-live-search="true" name="status" id="status" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                      <option value="1" selected>Active</option>
                      <option value="0">In-active</option>
                    </select>
                    <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">@lang('adminUser.status') <span class="text-red">*</span></label>
                  </div>
                </div>
              </div>


            </div><!-- End general information div-->


            <div class="col-md-6 discount">
              <div class="cards-btn">
                <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>
                <a href="{{ route('popular-travel.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
              </div>

            </div>
      </form>

    </div>
  </div>
  </div>
  </div>
  </div>
  </div>



  </div>
  <!-- /.row -->
  </div>
  <!-- End Row Div -->

  </div>

  <!-- End container fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
  $(document).ready(function() {
    // Initialize select2 for country dropdown
    $('#country_code').select2({
        placeholder: "Select Country",
        allowClear: true,
        width: '100%'
    });

    // Initialize select2 for city dropdowns
    $('.city-select').select2({
        placeholder: "Select City",
        allowClear: true,
        width: '100%'
    });

    // Function to fetch and populate city dropdowns
    function getCity(countryCode) {
        if (!countryCode) {
            $('.city-select').empty().append('<option value="">Select City</option>').trigger('change');
            return;
        }

        $.ajax({
            url: '/fetch-cities-by-country',
            type: 'GET',
            data: { country_code: countryCode },
            success: function(response) {
                if (response.length > 0) {
                    // Iterate over each city-select and update options
                    $('.city-select').each(function() {
                        var $select = $(this);
                        $select.empty().append('<option value="">Select City</option>');
                        response.forEach(function(city) {
                            $select.append(new Option(city.city_name, city.iso_code));
                        });

                        // Reinitialize select2
                        $select.trigger('change');
                    });
                } else {
                    alert('No cities found.');
                }
            },
            error: function(xhr, status, error) {
                alert('Error fetching cities: ' + error);
            }
        });
    }

    // Trigger getCity() when a country is selected
    $('#country_code').on('change', function() {
        var countryCode = $(this).val();
        getCity(countryCode);
    });
});

</script>

@append