@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
    .form-item input.is-valids+label {
        font-size: 11px;
        top: -5px;
    }

    .hidden {
        display: none;
    }

    .dark-mode .select2-container .select2-search--inline .select2-search__field {
        color: #222 !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #222 !important;
        padding-left: 25px !important;
    }

    input[readonly] {
        cursor: not-allowed;
    }
</style>


<!-- /.Start content-header -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">Popular Airline - View</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('popular-airline.index') }}">Popular Airline</a></li>
                    <li class="breadcrumb-item active">View</li>
                </ol>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
    <!-- Start container fluid -->
    <div class="container-fluid">
        <!-- Start Row Div -->
        <div class="row">

            <div class="card pb-4 pt-4 px-3 w-100">

    


                <div class="row mb-3">
                
                <h5 style="color:black;">Popular Airline</h5><hr style="color:black;"><br>
                    <table class="table table-borderd">
                        <tbody>
                        <tr>
                            <td style="color:black; font-weight:bold">Name: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->name }}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">URL: </td>
                            <td style="color:black;"> <a href="{{$popularAirlineDetails->url}}" target="_blank">{{$popularAirlineDetails->url}}</a> </td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Status: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->status == 1 ? 'Active' : 'Inactive' }}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Status: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->status ?? ''}}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Title : </td>
                            <td style="color:black;">{{ $popularAirlineDetails->title ?? ''}}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Arabic Title: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->arabic_title  ?? ''}}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Sub Title: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->sub_title  ?? ''}}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Arabic Sub Title: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->arabic_sub_title ?? ''}}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Arabic Banner Title: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->arabic_banner_title ?? '' }}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Banner Sub Title: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->status ?? '' }}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Arabic Banner Sub Title: </td>
                            <td style="color:black;">{{ $popularAirlineDetails->arabic_banner_sub_title  ?? '' }}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Uploaded Banner: </td>
                            <td><img data-toggle="popover"  height="150px" width="150px" src="{{ asset('storage/' . $popularAirlineDetails['banner']) ?: URL::asset('assets/images/no-image.png')}}" alt=""></td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Content: </td>
                            <td style="color:black;">{!! $popularAirlineDetails->content ?? '' !!}</td>
                        </tr>
                        <tr>
                            <td style="color:black; font-weight:bold">Arabic Content: </td>
                            <td style="color:black;">{!! $popularAirlineDetails->arabic_content ?? '' !!}</td>
                        </tr>
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
    </div>
    </div>



    </div>
    <!-- /.row -->
    </div>
    <!-- End Row Div -->

    </div>

    <!-- End container fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
    $(document).ready(function() {
        $('.airport_list').select2();
    });
</script>

@append