@extends('admin.layout.main')

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/2.3.3/css/dataTables.dataTables.css" />
<style>
    .dt-search input {
        width: 200px;
        height: 40px;
        padding: 3px 5px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    .dataTables_wrapper {
        padding-bottom: 0 !important;
        margin-bottom: 0 !important;
    }

    .dataTables_paginate {
        margin-top: 5px !important;
        margin-bottom: 0 !important;
    }

    .tab-content .tab-pane {
        max-height: 70vh;
        /* adjust as needed */
        overflow-y: auto;
        overflow-x: hidden;
        padding-bottom: 15px;
        /* avoid cutting pagination */
    }

    /* Only the table area scrolls */
    .table-wrapper {
        max-height: 70vh;
        /* adjust */
        overflow-y: auto;
    }
</style>


<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-9 d-flex breadcrumb-style">
                <h1 class="m-0">Sales Service Markups</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="#">Sales Service Markups</a></li>
                </ol>
            </div>
        </div>
    </div>
</div>

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                @if (session('success'))
                <div class="alert alert-success" role="alert">
                    <?php echo session('success'); ?>
                </div>
                @endif
                @if (session('error'))
                <div class="alert alert-danger" role="alert">
                    {{ session('error') }}
                </div>
                @endif
                @if (isset($error))
                <div class="alert alert-danger" role="alert">
                    {{ $error }}
                </div>
                @endif

                <div class="text-center mb-4">
                    <button class="btn btn-primary mx-2" onclick="showSection('flight')">✈️ Flight Markups</button>
                    <button class="btn btn-secondary mx-2" onclick="showSection('hotel')">🏨 Hotel Markups</button>
                </div>

                {{-- Flight Section --}}
                <div id="flight-section">
                    <div class="row">
                        <div class="col text-start">
                            <h5 style="font-weight: bold;">Flight Sales Markup</h5>
                        </div>
                        <div class="col text-end">
                            <div class="breadcrumb-btn mb-3">
                                <div class="add-breadcrumb">
                                    <a href="{{ route('flight-sales-markups.create') }}" class="btn btn-primary">
                                        <span style="color: white;">➕</span> Add
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>


                    @include('admin.markups.sales.flight-markups')
                </div>

                {{-- Hotel Section --}}
                <div id="hotel-section" style="display:none;">
                    <div class="row">
                        <div class="col text-start">
                            <h5 style="font-weight: bold;">Hotel Sales Markup</h5>
                        </div>
                        <div class="col text-end">
                            <div class="breadcrumb-btn mb-3">
                                <div class="add-breadcrumb">
                                    <a href="{{ route('hotel-sales-markups.create') }}" class="btn btn-primary">
                                        <span style="color: white;">➕</span> Add
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>

                    @include('admin.markups.sales.hotel-markups')
                </div>




            </div>


        </div>
    </div>
    </div>
    </div>
</section>
@endsection

@section('js')
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>



<script src="https://cdn.datatables.net/2.3.3/js/dataTables.js"></script>

<script>
    $(document).ready(function() {
        let flightTable = $('#flightSalesMarkupTable').DataTable({
            pageLength: 10,
            lengthChange: false,
            ordering: true,
            info: false,
            autoWidth: false,
            searching: true,
            columnDefs: [{
                orderable: false,
                targets: -1
            }]
        });

        let hotelTable = $('#hotelSalesMarkupTable').DataTable({
            pageLength: 10,
            lengthChange: false,
            ordering: true,
            info: false,
            autoWidth: false,
            searching: true,
            columnDefs: [{
                orderable: false,
                targets: -1
            }]
        });

        $('a[data-bs-toggle="tab"]').on('shown.bs.tab', function() {
            $.fn.dataTable.tables({
                visible: true,
                api: true
            }).columns.adjust();
        });
    });
</script>
<script>
    function showSection(section) {
        // Hide all
        document.getElementById('flight-section').style.display = 'none';
        document.getElementById('hotel-section').style.display = 'none';

        // Show selected
        document.getElementById(section + '-section').style.display = 'block';
    }
</script>
@append