<div class="table-card">
    <div class="card-body table-radius table-responsive p-0">
        <table class="table table-head-fixed text-nowrap table-wrapper" id="flightSalesMarkupTable" >
        <thead style="background-color: #343A40; color: white">
            <tr>
                <th>S.No</th>
                <th>Service Name</th>
                <th>Service Type</th>
                <th>Cabin Class</th>
                <th>Sales Service Type</th>
                <th>Status</th>
                <th>Created By</th>
                <th>Created At</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($flightSalesMarkups as $index => $markup)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>{{ 'Flight' }}</td>
                <td>{{ ucfirst($markup->service_type) }}</td>
                <td>{{ ucwords(str_replace('_', ' ', $markup->cabin_class)) }}</td>
                <td>{{ ucwords(str_replace('_', ' / ', $markup->sales_service_type)) }}</td>
                <td>
                    @if($markup->status === 'active')
                    <span class="badge badge-success">Active</span>
                    @else
                    <span class="badge badge-danger">Inactive</span>
                    @endif
                </td>
                <td>{{ optional($markup->creator)->name }}</td>
                <td>{{ $markup->created_at->format('d M, Y') }}</td>
                <td>
                    <span>
          <a href="{{ route('flight-sales-markups.edit', $markup?->id) }}" title="Edit">
            <?xml version="1.0"?><svg fill="#198754" viewBox="0 0 24 24" width="20" height="20">
              <path
                d="M 19.171875 2 C 18.448125 2 17.724375 2.275625 17.171875 2.828125 L 16 4 L 20 8 L 21.171875 6.828125 C 22.275875 5.724125 22.275875 3.933125 21.171875 2.828125 C 20.619375 2.275625 19.895625 2 19.171875 2 z M 14.5 5.5 L 3 17 L 3 21 L 7 21 L 18.5 9.5 L 14.5 5.5 z" />
            </svg></a></span>

        <span>
            <a data-url="{{ route('flight-sales.markups.delete', ['id' => $markup?->id]) }}" data-bs-toggle="modal" data-bs-target="#exampleModal" type="button" title="Delete"
                class="deleteConfirmation btn-hover-del"><svg fill="#ee3137" viewBox="0 0 24 24"
                width="20" height="20">
                <path
                    d="M 10 2 L 9 3 L 5 3 C 4.4 3 4 3.4 4 4 C 4 4.6 4.4 5 5 5 L 7 5 L 17 5 L 19 5 C 19.6 5 20 4.6 20 4 C 20 3.4 19.6 3 19 3 L 15 3 L 14 2 L 10 2 z M 5 7 L 5 20 C 5 21.1 5.9 22 7 22 L 17 22 C 18.1 22 19 21.1 19 20 L 19 7 L 5 7 z M 9 9 C 9.6 9 10 9.4 10 10 L 10 19 C 10 19.6 9.6 20 9 20 C 8.4 20 8 19.6 8 19 L 8 10 C 8 9.4 8.4 9 9 9 z M 15 9 C 15.6 9 16 9.4 16 10 L 16 19 C 16 19.6 15.6 20 15 20 C 14.4 20 14 19.6 14 19 L 14 10 C 14 9.4 14.4 9 15 9 z" />
                </svg></a>

            </span>
                </td>
            </tr>
            @endforeach
        </tbody>
            </table>
        </div>
    </div>