<style>
    textarea.select2-search__field {
        width: 40.50em !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #000 !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
        margin-left: 5px;
    }
</style>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<section class="content">

    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 w-100 px-3 py-2 mb-3">
                <form id="dataForm" name="dataForm" class="form row mb-0 pt-3 validate" action="{{ route('markups.storeHotelMarkup') }}" enctype="multipart/form-data" method="post">
                    @csrf
                    <input type="hidden" name="service_type_id" value="{{ $serviceTypeId ?? '' }}">

                    @php
                    $serviceType = $_GET['service_type'];
                    @endphp
                    <div class="col-md-12">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="serviceType" name="serviceType" class="order-td-input selectpicker select-text height_drp is-valid" style="width: 100%;" onchange="fetchServiceType()">

                                            <option value="hotel" @if($serviceType=='Hotel' ) selected @endif>Hotel</option>
                                            <option value="flight" @if($serviceType=='flight' ) selected @endif>Flight</option>

                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Service Type </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="channel" name="channel[]" class="order-td-input selectpicker select-text height_drp is-valid" style="width: 100%;" multiple>
                                            <option value="b2b">B2B</option>
                                            <option value="b2c_desktop">B2C Desktop</option>
                                            <option value="b2c_mobile_app">B2C Mobile App</option>
                                            <option value="b2c_mobile_browser">B2C Mobile Browser</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Channel </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    {{--<div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="supplier" name="supplier[]" class="order-td-input selectpicker select-text height_drp is-valid" placeholder="Select Supplier" style="width:100%;" multiple></select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Suppliers </label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>--}}

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="destinationCriteria" name="destinationCriteria" class="order-td-input selectpicker select-text height_drp is-valid" style="width: 100%;">
                                            <option value="all">All</option>
                                            <option value="country">Country</option>
                                            <option value="city">City</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Destination Criteria <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id="destinationNameAll">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="destinationName" name="destinationName" class="order-td-input select-text height_drp is-valid select2" style="width: 100%;" disabled>
                                            <option value="all" selected>All</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Destination Name <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id="destinationNameCountry">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="CountryDList" name="destinationName" class="order-td-input select-text height_drp is-valid select2 destination_country_list" style="width: 100%;">
                                            <option value="all">All</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Destination Name <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6" id="destinationNameCity">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="CityDList" name="destinationName" class="order-td-input select-text height_drp is-valid select2 CityOList" style="width: 100%;" placeholder="Select Airport">
                                            <option value="all">All</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Destination Name <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="fromBookingDate" id="fromBookingDate" autocomplete="off" required placeholder="DD/MM/YYYY" class="is-valid">
                                <label for="">From Booking Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="toBookingDate" id="toBookingDate" autocomplete="off" required class="is-valid" placeholder="DD/MM/YYYY">
                                <label for="">To Booking Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="fromCheckInDate" id="fromCheckInDate" autocomplete="off" required class="is-valid" placeholder="DD/MM/YYYY">
                                <label for="">From CheckIn Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="toCheckInDate" id="toCheckInDate" autocomplete="off" required class="is-valid" placeholder="DD/MM/YYYY">
                                <label for="">To CheckIn Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="starCategory" name="starCategory[]" class="order-td-input selectpicker select-text height_drp is-valid" style="width: 100%;" multiple>
                                            <option value="1Star">1Star</option>
                                            <option value="2Star">2Star</option>
                                            <option value="3Star">3Star</option>
                                            <option value="4Star">4Star</option>
                                            <option value="5Star">5Star</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Star Category <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select class="order-td-input selectpicker select2 select-text height_drp is-valid" id="agentName" name="agentName[]" multiple="multiple" style="width: 100%;">
                                            <option value="">Select Agent Name</option>
                                            @foreach($getAgency as $agency)
                                            <option value="{{ $agency['id'] }}">{{ $agency['full_name'] ?? '' }} </option>
                                            @endforeach
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Agent Name</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select class="order-td-input selectpicker select2 select-text height_drp is-valid" id="agentGroup" name="agentGroup" style="width: 100%;">
                                            <option value="">Select Agent Group</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Agent Group</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="text" name="fromBaseFare" id="fromBaseFare" autocomplete="off" required step="any">
                                <label for="from_base_fare">From Base Fare <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="text" name="toBaseFare" id="toBaseFare" autocomplete="off" required step="any">
                                <label for="to_base_fare">To Base Fare <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="fareType" name="fareType" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option disabled selected>Select Fare Type</option>
                                            <option value="commission">Commission</option>
                                            <option value="net_fare">Net Fare</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Fare Type <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="calculationMethod" name="calculationMethod" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option disabled selected>Select Calculation Method</option>
                                            <option value="from_total">From Total Amount</option>
                                            <option value="per_room">Per Room</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select Service Fee Calculation Method<span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="b2c_markup_type" name="b2c_markup_type" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option selected value="percentage">%Percentage</option>
                                            <option value="fixed_amount">Fixed amount</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select B2C Markup Type <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="number" name="b2c_markup" id="b2c_markup" autocomplete="off" required step="any">
                                <label for="b2c_markup">B2C Markup Value <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="b2b_markup_type" name="b2b_markup_type" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option selected value="percentage">%Percentage</option>
                                            <option value="fixed_amount">Fixed amount</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Select B2B Markup Type<span class="req-star"></span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 row mb-3">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="number" name="b2b_markup" id="b2b_markup" autocomplete="off" step="any">
                                <label for="b2b_markup">B2B Markup Value</label>
                            </div>
                        </div>
                    </div>


                    <!-- Service Markup Type -->

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="service_b2c_markup_type" name="service_b2c_markup_type" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option selected value="percentage">%Percentage</option>
                                            <option value="fixed_amount">Fixed amount</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Service B2C Markup Type <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="number" name="service_b2c_markup" id="service_b2c_markup" autocomplete="off" required step="any">
                                <label for="b2c_markup">Service B2C Markup Value <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <!-- End of Service Markup type -->

                    <!-- Service Markup Value -->

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="service_b2b_markup_type" name="service_b2b_markup_type" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option selected value="percentage">%Percentage</option>
                                            <option value="fixed_amount">Fixed amount</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Service B2B Markup Type<span class="req-star"></span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6 row mb-3">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="number" name="service_b2b_markup" id="service_b2b_markup" autocomplete="off" step="any">
                                <label for="b2b_markup">Service B2B Markup Value</label>
                            </div>
                        </div>
                    </div>

                    <!--End  Service Markup Value -->


                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <label for="" style="color: #999 !important;">Comm On/Markup On <span class="req-star">*</span></label>
                            <div class="q-a mb-2">
                                <div class="form-check">
                                    <input type="radio" id="comm_markup_base_fare" name="commMarkupOn" data-change="commMarkupOn" class="form-check-input is-valid" value="base_fare" required>
                                    <label class="form-check-label" for="comm_markup_base_fare">Base Fare</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" id="comm_markup_base_fare_yq" name="commMarkupOn" data-change="commMarkupOn" class="form-check-input is-valid" value="base_fare_yq" required>
                                    <label class="form-check-label" for="comm_markup_base_fare_yq">Base Fare+Tax</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" id="comm_markup_net_fare" name="commMarkupOn" data-change="commMarkupOn" class="form-check-input is-valid" value="net_fare" required>
                                    <label class="form-check-label" for="comm_markup_net_fare">Net Fare</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" id="comm_markup_total_fare" name="commMarkupOn" data-change="commMarkupOn" class="form-check-input is-valid" value="total_fare" required>
                                    <label class="form-check-label" for="comm_markup_total_fare">Total Fare</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-6">
                        <div class="col-md-12">
                            <div class="form-item form-float-style form-group">
                                <input type="text" name="priority" id="priority" autocomplete="off" required step="any">
                                <label for="priority">Priority <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="cards-btn">
                        <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>


                </form>



            </div>
        </div>
        <!-- /.row -->
    </div>
    <!--/. container-fluid -->
</section>
@section('js')
<script>
    $("#channel").select2();
    $("#starCategory").select2();
    $("#agency").select2();
    $("#agencyGroup").select2();

    $(document).ready(function() {
        $("#originNameAll").show();
        $("#originNameCountry").hide();
        $("#originNameCity").hide();
        $("#originNameAirport").hide();
        $('#originCriteria').on('change', function() {
            var origin_criteria = $(this).val();
            if (origin_criteria == 'all') {
                $("#originNameAll").show();
                $("#originNameCountry").hide();
                $("#originNameCity").hide();
                $("#originNameAirport").hide();
            } else if (origin_criteria == 'country') {
                $("#originNameAll").hide();
                $("#originNameCountry").show();
                $("#originNameCity").hide();
                $("#originNameAirport").hide();
            } else if (origin_criteria == 'city') {
                $("#originNameAll").hide();
                $("#originNameCountry").hide();
                $("#originNameCity").show();
                $("#originNameAirport").hide();
            } else if (origin_criteria == 'airport') {
                $("#originNameAll").hide();
                $("#originNameCountry").hide();
                $("#originNameCity").hide();
                $("#originNameAirport").show();
            }
        });
    });

    $(document).ready(function() {
        $("#destinationNameAll").show();
        $("#destinationNameCountry").hide();
        $("#destinationNameCity").hide();
        $("#destinationNameAirport").hide();
        $('#destinationCriteria').on('change', function() {
            var destination_criteria = $(this).val();
            if (destination_criteria == 'all') {
                $("#destinationNameAll").show();
                $("#destinationNameCountry").hide();
                $("#destinationNameCity").hide();
                $("#destinationNameAirport").hide();
            } else if (destination_criteria == 'country') {
                $("#destinationNameAll").hide();
                $("#destinationNameCountry").show();
                $("#destinationNameCity").hide();
                $("#destinationNameAirport").hide();
            } else if (destination_criteria == 'city') {
                $("#destinationNameAll").hide();
                $("#destinationNameCountry").hide();
                $("#destinationNameCity").show();
                $("#destinationNameAirport").hide();
            } else if (destination_criteria == 'airport') {
                $("#destinationNameAll").hide();
                $("#destinationNameCountry").hide();
                $("#destinationNameCity").hide();
                $("#destinationNameAirport").show();
            }
        });
    });

    $(document).ready(function domReady() {
        $(".js-select2").select2({
            placeholder: "Select Airlines",
            theme: "material"
        });

        $(".select2-selection__arrow")
            .addClass("material-icons")
            .html("arrow_drop_down");
    });

    var dateToday = new Date();
    $(function() {
        $("#fromBookingDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#toBookingDate").datepicker("option", "minDate", selected);
                $(this).valid();
            }
        });
        $("#toBookingDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#fromBookingDate").datepicker("option", "maxDate", selected);
                $(this).valid();
            }
        });
    });

    $(function() {
        $("#fromCheckInDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#toCheckInDate").datepicker("option", "minDate", selected);
                $(this).valid();
            }
        });
        $("#toCheckInDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#fromCheckInDate").datepicker("option", "maxDate", selected);
                $(this).valid();
            }
        });
    });
</script>
<script>
    $(function() {

        $.validator.addMethod('numbersOnly', function(value, element) {
            return this.optional(element) || /^[0-9]+(\.[0-9]+)?$/.test(value);
        }, 'Please enter a valid number');

        $('*[value=""]').removeClass('is-valid');

        $('#dataForm').validate({
            rules: {
                "ruleName": {
                    required: true,
                },


                "origin": {
                    required: true,
                },
                "destination": {
                    required: true,
                },
                "airlines[]": {
                    required: true,
                },
                "fromBookingDate": {
                    required: true,
                },
                "toBookingDate": {
                    required: true,
                },
                "fromCheckInDate": {
                    required: true,
                },
                "toCheckInDate": {
                    required: true,
                },

                "tripType": {
                    required: true,
                },
                "starCategory[]": {
                    required: true,
                },
                "agentName[]": {
                    required: true,
                },

                "fromBaseFare": {
                    required: true,
                    noSpace: true,
                    numbersOnly: true,
                },
                "toBaseFare": {
                    required: true,
                    noSpace: true,
                    numbersOnly: true,
                },
                "b2c_markup_type": {
                    required: true,
                },
                "b2c_markup": {
                    required: true,
                },
                "fareType": {
                    required: true,
                },
                "priority": {
                    required: true,
                    noSpace: true,
                    numbersOnly: true,
                },
                'commMarkupOn': {
                    required: true
                },
                'calculationMethod': {
                    required: true
                }
            },
            messages: {
                "ruleName": {
                    required: "Please enter a rule name",
                },

                "origin": {
                    required: "Please select an Origin",
                },
                "destination": {
                    required: "Please select a Destination",
                },
                "starCategory[]": {
                    required: "Please select a Star Category",
                },
                "agentName[]": {
                    required: "Please select an Agent Name",
                },

                "fromBookingDate": {
                    required: "Please select a From Booking Date",
                },
                "toBookingDate": {
                    required: "Please select a To Booking Date",
                },
                "fromCheckInDate": {
                    required: "Please select a From CheckIn Date",
                },
                "toCheckInDate": {
                    required: "Please select a To CheckIn Date",
                },

                "tripType": {
                    required: "Please select a Trip Type",
                },
                "paxType": {
                    required: "Please select a Pax Type",
                },
                "fromBaseFare": {
                    required: "Please enter a From Base Fare",
                    numbersOnly: 'Please enter only numbers',
                },
                "toBaseFare": {
                    required: "Please select a To Base Fare",
                    numbersOnly: 'Please enter only numbers',
                },
                "b2c_markup_type": {
                    required: "Please select a B2C Markup Type",
                },
                "b2c_markup": {
                    required: "Please enter a B2C Markup",
                },
                "fareType": {
                    required: "Please select a Fare Type",
                },
                "priority": {
                    required: "Please enter a Priority",
                    numbersOnly: 'Please enter only numbers',
                },
                "commMarkupOn": {
                    required: "Please Select a Comm On/Markup On"
                },
                "calculationMethod": {
                    required: "Please Select Calculation Type",
                },
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function(form) {
                $("#disBtn").attr("disabled", true);
                form.submit();
            }
        });

    });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>
<script>
    $('#CountryList, #CountryDList').select2({
        ajax: {
            url: '/get-country-name',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term,
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var mappedData = $.map(data, function(country) {
                    return {
                        id: country.iso_code,
                        text: country.cname
                    };
                });

                mappedData.unshift({
                    id: 'all',
                    text: 'All'
                });

                return {
                    results: mappedData,
                    pagination: {
                        more: mappedData.length >= 10
                    }
                };
            },
            cache: true
        }
    });
</script>
<script>
    $('#CityOList, #CityDList').select2({
        ajax: {
            url: '/get-only-city-name',
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term,
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var mappedData = $.map(data, function(city) {
                    return {
                        id: city.iso_code,
                        text: city.cname
                    };
                });

                mappedData.unshift({
                    id: 'all',
                    text: 'All'
                });

                return {
                    results: mappedData,
                    pagination: {
                        more: mappedData.length >= 10
                    }
                };
            },
            cache: true
        },
        placeholder: 'Select city',
    });
</script>
<script>
    $('.origin_airport_list, .destination_airport_list').select2({
        ajax: {
            url: "{{ route('markups.fetchOrigin') }}",
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term,
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var mappedData = $.map(data, function(airport) {
                    return {
                        id: airport.id,
                        text: airport.airname
                    };
                });

                mappedData.unshift({
                    id: 'all',
                    text: 'All'
                });

                return {
                    results: mappedData,
                    pagination: {
                        more: mappedData.length >= 10
                    }
                };
            },
            cache: true
        },
        minimumInputLength: 0
    });



    $('#airlines').select2({
        ajax: {
            url: "{{ route('markups.fetchAirlines') }}",
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term,
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var mappedData = $.map(data, function(airline) {
                    return {
                        id: airline.id,
                        text: airline.airname
                    };
                });

                return {
                    results: mappedData,
                    pagination: {
                        more: mappedData.length >= 10
                    }
                };
            },
            cache: true
        },
        minimumInputLength: 0
    });

    $('#supplier').select2({
        ajax: {
            url: "{{ route('markups.fetchSupplier') }}",
            // dataType: 'json',
            type: "get",
            delay: 250,
            data: function(params) {
                return {
                    q: params.term || '',
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var results = [];
                console.log('supplier data :', data);

                data.forEach(function(option) {
                    results.push({
                        id: option.id,
                        text: option.name
                    });
                });

                return {
                    results: results,
                    pagination: {
                        more: data.length >= 10 // Adjust based on your pagination logic
                    }
                };
            },
            cache: true
        },
        minimumInputLength: 0
    });


    function fetchServiceType() {
        const serviceType = document.getElementById('serviceType').value;
        if (serviceType == 'flight') {
            window.location.href = "{{ route('markups.created',['service_type'=>'flight']) }}";
        } else if (serviceType == 'hotel') {
            window.location.href = "{{ route('markups.created',['service_type'=>'hotel']) }}";
        }
    }
</script>
@append