<style>
    textarea.select2-search__field {
        width: 40.50em !important;
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #000 !important;
    }
</style>
<section class="content">
    <div class="container-fluid">
        <!-- Info boxes -->
        <div class="row">
            <div class="card pb-4 w-100 px-3 py-2 mb-3">
                <form id="dataForm" name="dataForm" class="form row mb-0 pt-3 validate" action="{{ route('mark-ups.store') }}" enctype="multipart/form-data" method="post">
                    @csrf
                    <input type="hidden" name="service_type_id" value="{{ $serviceTypeId ?? '' }}">

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="channel" name="channel[]" class="order-td-input selectpicker select-text height_drp is-valid" style="width: 100%;" multiple>
                                            <option value="back_office">BackOffice</option>
                                            <option value="b2c">B2C</option>
                                            <option value="b2b">B2B</option>
                                            <option value="mobile">Mobile</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Channel <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="supplier" name="supplier[]" class="order-td-input selectpicker select-text height_drp is-valid" placeholder="Select Supplier" style="width:100%;" multiple></select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Suppliers <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="origin" name="origin" class="order-td-input select-text height_drp is-valid select2" style="width: 100%;" placeholder="Select Origin">
                                            <option disabled selected>Select Origin</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Origin <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="destination" name="destination" class="order-td-input select-text height_drp is-valid" style="width: 100%;">
                                            <option disabled selected>Select Destination</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Destination <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="airlines" name="airlines[]" class="order-td-input select-text height_drp is-valid" style="width: 100%;" multiple>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Airlines <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row">
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="fromBookingDate" id="fromBookingDate" autocomplete="off" required placeholder="DD/MM/YYYY" class="is-valid">
                                <label for="">From Booking Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="toBookingDate" id="toBookingDate" autocomplete="off" required class="is-valid" placeholder="DD/MM/YYYY">
                                <label for="">To Booking Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row">
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="fromTravelDate" id="fromTravelDate" autocomplete="off" required class="is-valid" placeholder="DD/MM/YYYY">
                                <label for="">From Travel Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid datepicker" name="toTravelDate" id="toTravelDate" autocomplete="off" required class="is-valid" placeholder="DD/MM/YYYY">
                                <label for="">To Travel Date <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="bookingClass" name="bookingClass" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option disabled selected>Select Booking Class</option>
                                            @foreach (range('A', 'Z') as $letter)
                                            <option value="{{ $letter }}"> {{ $letter }}</option>
                                            @endforeach
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Booking Class <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="cabinClass" name="cabinClass" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option disabled selected>Select Cabin Class</option>
                                            <option value="first">First</option>
                                            <option value="business">Business</option>
                                            <option value="premium_economy">Premium Economy</option>
                                            <option value="economy">Economy</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Cabin Class <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="tripType" name="tripType" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option disabled selected>Select Trip Type</option>
                                            <option value="one_way">One Way</option>
                                            <option value="round_trip">Round Trip</option>
                                            <option value="multi_city">Multi City</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Trip Type <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="paxType" name="paxType" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option disabled selected>Select Pax Type</option>
                                            <option value="adult">Adult</option>
                                            <option value="child">Child</option>
                                            <option value="infant">Infant</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Pax Type <span class="req-star">*</span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row">
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid" name="fromBaseFare" id="fromBaseFare" autocomplete="off" required placeholder="">
                                <label for="">From Base Fare <span class="req-star">*</span></label>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="text" class="is-valid" name="toBaseFare" id="toBaseFare" autocomplete="off" required placeholder="">
                                <label for="">To Base Fare <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <label for="" style="color: #999 !important;">Fare Type</label>
                            <div class="q-a mb-2">
                                <div class="form-check">
                                    <input type="radio" id="fare_type_commission" name="fareType" data-change="fareType" class="form-check-input" value="commission" checked>
                                    <label class="form-check-label" for="fare_type_commission">Commission</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" id="fare_type_net_fare" name="fareType" data-change="fareType" class="form-check-input" value="net_fare">
                                    <label class="form-check-label" for="fare_type_net_fare">Net Fare</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-3">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="b2c_markup_type" name="b2c_markup_type" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option selected value="percentage">%Percentage</option>
                                            <option value="fixed_amount">Fixed amount</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">B2C Markup Type<span class="req-star"></span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="number" name="b2c_markup" id="b2c_markup" autocomplete="off" required step="any">
                                <label for="b2c_markup">B2C Markup <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-3">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style serach-rem mb-0">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" id="b2b_markup_type" name="b2b_markup_type" class="order-td-input selectpicker select-text height_drp is-valid">
                                            <option selected value="percentage">%Percentage</option>
                                            <option value="fixed_amount">Fixed amount</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">B2B Markup Type<span class="req-star"></span></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="form-item form-float-style form-group">
                                <input type="number" name="b2b_markup" id="b2b_markup" autocomplete="off" required step="any">
                                <label for="b2b_markup">B2B Markup <span class="req-star">*</span></label>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <label for="" style="color: #999 !important;">Comm On/Markup On</label>
                            <div class="q-a mb-2">
                                <div class="form-check">
                                    <input type="radio" id="comm_markup_base_fare" name="commMarkupOn" data-change="commMarkupOn" class="form-check-input" value="base_fare" checked>
                                    <label class="form-check-label" for="comm_markup_base_fare">Base Fare</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" id="comm_markup_base_fare_yq" name="commMarkupOn" data-change="commMarkupOn" class="form-check-input" value="base_fare_yq">
                                    <label class="form-check-label" for="comm_markup_base_fare_yq">Base Fare+YQ</label>
                                </div>
                                <div class="form-check">
                                    <input type="radio" id="comm_markup_net_fare" name="commMarkupOn" data-change="commMarkupOn" class="form-check-input" value="net_fare">
                                    <label class="form-check-label" for="comm_markup_net_fare">Net Fare</label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-md-12 row mb-3">
                        <div class="col-md-6">
                            <div class="form-floating form-item mb-0">
                                <div class="form-item form-float-style form-group">
                                    <input type="text" name="priority" id="priority" class="is-valid" required>
                                    <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Priority <span class="req-star">*</span></label>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="cards-btn">
                        <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>
                        <a href="{{ route('markups.service_types',['service_type'=>$serviceTypes]) }}" class="btn btn-danger form-btn-danger">Cancel</a>
                    </div>

                </form>



            </div>
        </div>
        <!-- /.row -->
    </div>
    <!--/. container-fluid -->
</section>
@section('js')
<script>
    $("#channel").select2();

    $(document).ready(function domReady() {
        $(".js-select2").select2({
            placeholder: "Select Airlines",
            theme: "material"
        });

        $(".select2-selection__arrow")
            .addClass("material-icons")
            .html("arrow_drop_down");
    });

    var dateToday = new Date();
    $(function() {
        $("#fromBookingDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#toBookingDate").datepicker("option", "minDate", selected);
                $(this).valid();
            }
        });
        $("#toBookingDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#fromBookingDate").datepicker("option", "maxDate", selected);
                $(this).valid();
            }
        });
    });

    $(function() {
        $("#fromTravelDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#toTravelDate").datepicker("option", "minDate", selected);
                $(this).valid();
            }
        });
        $("#toTravelDate").datepicker({
            dateFormat: 'dd-mm-yy',
            minDate: dateToday,
            onClose: function(selected) {
                $("#fromTravelDate").datepicker("option", "maxDate", selected);
                $(this).valid();
            }
        });
    });
</script>
<script>
    $(function() {

        $.validator.addMethod('numbersOnly', function(value, element) {
            return this.optional(element) || /^[0-9]+(\.[0-9]+)?$/.test(value);
        }, 'Please enter a valid number');

        $('*[value=""]').removeClass('is-valid');

        $('#dataForm').validate({
            rules: {
                "channel[]": {
                    required: true,
                },
                "supplier[]": {
                    required: true,
                },
                "origin": {
                    required: true,
                },
                "destination": {
                    required: true,
                },
                "airlines[]": {
                    required: true,
                },
                "fromBookingDate": {
                    required: true,
                },
                "toBookingDate": {
                    required: true,
                },
                "fromTravelDate": {
                    required: true,
                },
                "toTravelDate": {
                    required: true,
                },
                "bookingClass": {
                    required: true,
                },
                "cabinClass": {
                    required: true,
                },
                "tripType": {
                    required: true,
                },
                "paxType": {
                    required: true,
                },
                "fromBaseFare": {
                    required: true,
                    noSpace: true,
                    numbersOnly: true,
                },
                "toBaseFare": {
                    required: true,
                    noSpace: true,
                    numbersOnly: true,
                },
                "b2c_markup_type": {
                    required: true,
                },
                "b2c_markup": {
                    required: true,
                },
                "b2b_markup_type": {
                    required: true,
                },
                "b2b_markup": {
                    required: true,
                },
                "priority": {
                    required: true,
                    noSpace: true,
                    numbersOnly: true,
                },

            },

            messages: {
                "channel[]": {
                    required: "Please select an Channel",
                },
                "supplier[]": {
                    required: "Please select a Suppliers",
                },
                "origin": {
                    required: "Please select an Origin",
                },
                "destination": {
                    required: "Please select a Destination",
                },
                "airlines[]": {
                    required: "Please select an Airlines",
                },
                "fromBookingDate": {
                    required: "Please select a From Booking Date",
                },
                "toBookingDate": {
                    required: "Please select a To Booking Date",
                },
                "fromTravelDate": {
                    required: "Please select a From Travel Date",
                },
                "toTravelDate": {
                    required: "Please select a To Travel Date",
                },
                "bookingClass": {
                    required: "Please select a Booking Class",
                },
                "cabinClass": {
                    required: "Please select a Cabin Class",
                },
                "tripType": {
                    required: "Please select a Trip Type",
                },
                "paxType": {
                    required: "Please select a Pax Type",
                },
                "fromBaseFare": {
                    required: "Please enter a From Base Fare",
                    numbersOnly: 'Please enter only numbers',
                },
                "toBaseFare": {
                    required: "Please select a To Base Fare",
                    numbersOnly: 'Please enter only numbers',
                },
                "b2c_markup_type": {
                    required: "Please select a B2C Markup Type",
                },
                "b2c_markup": {
                    required: "Please Enter a B2C Markup",
                },
                "b2b_markup_type": {
                    required: "Please select a B2B Markup Type",
                },
                "b2b_markup": {
                    required: "Please Enter a B2B Markup",
                },
                "priority": {
                    required: "Please Enter a Priority",
                    numbersOnly: 'Please enter only numbers',
                },
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element, errorClass, validClass) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element, errorClass, validClass) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function(form) {
                $("#disBtn").attr("disabled", true);
                form.submit();
            }
        });

    });
</script>

<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>
<script>
    $('#origin,#destination').select2({
        ajax: {
            url: "{{ route('markups.fetchOrigin') }}",
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term,
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var mappedData = $.map(data, function(airport) {
                    return {
                        id: airport.id,
                        text: airport.airname
                    };
                });

                return {
                    results: mappedData,
                    pagination: {
                        more: mappedData.length >= 10
                    }
                };
            },
            cache: true
        },
        minimumInputLength: 0
    });

    $('#airlines').select2({
        ajax: {
            url: "{{ route('markups.fetchAirlines') }}",
            dataType: 'json',
            delay: 250,
            data: function(params) {
                return {
                    term: params.term,
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var mappedData = $.map(data, function(airline) {
                    return {
                        id: airline.id,
                        text: airline.airname
                    };
                });

                return {
                    results: mappedData,
                    pagination: {
                        more: mappedData.length >= 10
                    }
                };
            },
            cache: true
        },
        minimumInputLength: 0
    });

    $('#supplier').select2({

        ajax: {
            url: "{{ route('markups.fetchSupplier') }}",
            // dataType: 'json',
            type: "get",
            delay: 250,
            data: function(params) {
                return {
                    q: params.term || '',
                    page: params.page || 1,
                    "_token": '{{ csrf_token() }}'
                };
            },
            processResults: function(data) {
                var results = [];
                console.log('supplier data :', data);

                data.forEach(function(option) {
                    results.push({
                        id: option.id,
                        text: option.name
                    });
                });

                return {
                    results: results,
                    pagination: {
                        more: data.length >= 10 // Adjust based on your pagination logic
                    }
                };
            },
            cache: true
        },
        minimumInputLength: 0
    });
</script>
@append