@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
    textarea.select2-search__field {
        width: 40.50em !important;
   
    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice {
        color: #000 !important;

    }

    .select2-container--default .select2-selection--multiple .select2-selection__choice__display {
        margin-left: 5px;

    }

    #logic_rule,
    #hotels {
        transition: all 0.2s ease-in-out;
    }

 .select2-container--default.select2-container--open .select2-search--inline .select2-search__field {
    color: #000 !important;
}
</style>


<!-- /.Start content-header -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-12 d-flex breadcrumb-style">
                <h1 class="m-0">Hotel Recommendation Control - Add</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="{{ route('hotel-recommendation.index') }}">Hotel Recommendation Control</a></li>
                    <li class="breadcrumb-item active">Add</li>
                </ol>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
    <!-- Start container fluid -->
    <div class="container-fluid">
        <!-- Start Row Div -->
        <div class="row">
            <form id="basicForm" class="form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('hotel-recommendation.store') }}" method="post" enctype="multipart/form-data">
                <div class="card pb-4 pt-4 px-3 w-100">

                    <div class="col-md-12">
                        <div class="form-group">
                            @if (session('success'))
                            <div class="alert alert-success" role="alert">
                                <?php echo session('success'); ?>
                            </div>
                            @endif
                            @if (session('error'))
                            <div class="alert alert-danger" role="alert">
                                {{ session('error') }}
                            </div>
                            @endif
                            @if (isset($error))
                            <div class="alert alert-danger" role="alert">
                                {{ $error }}
                            </div>
                            @endif
                        </div>
                    </div>

                    <div class="row mb-3">
                        @csrf
                        <div class="col-md-6">
                            <div class="form-floating form-float-style form-group required mb-3">
                                <div class="form-item form-float-style serach-rem mb-3">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" name="recommendation_type" id="recommendation_type" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                                            <option value="general_logic" selected>General Logic</option>
                                            <option value="manual_selection">Manual Selection</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Recommendation Type<span class="text-red">*</span></label>
                                        @error('recommendation_type')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-item form-float-style form-group">
                                <select
                                    name="destination"
                                    id="destination"
                                    class="form-control select2"
                                    style="width: 100%;">
                                </select>
                                <label for="destination">Destination <span class="req-star"> *</span></label>
                                @error('destination')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-item form-float-style form-group" style="color:black">
                                <select
                                    name="hotels[]"
                                    id="hotels"
                                    class="form-control select2"
                                    multiple="multiple"
                                    style="width: 100%;">
                                </select>
                                <label for="hotels">Hotels <span class="req-star"> *</span></label>
                                @error('hotels')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating form-float-style form-group required mb-3">
                                <div class="form-item form-float-style serach-rem mb-3">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" name="logic_rule" id="logic_rule" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                                            <option value="top_rated_hotels" selected>Top Rated Hotels</option>
                                            <option value="most_booked_hotels">Most Booked Hotels</option>
                                            <option value="highest_margin_hotels">Highest Margin Hotels</option>
                                            <option value="closed_to_city_center">Closest to City Center</option>
                                            <option value="cheapest_rate">Cheapest Rate</option>
                                            <option value="newly_added_hotels">Newly Added Hotels</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Logic Rule<span class="text-red">*</span></label>
                                        @error('logic_rule')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-floating form-float-style form-group required mb-3">
                                <div class="form-item form-float-style serach-rem mb-3">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" name="priority_level" id="priority_level" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                                            <option value="high" selected>High</option>
                                            <option value="medium">Medium</option>
                                            <option value="low">Low</option>
                                            <option value="override">Override</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Priority Rule<span class="text-red">*</span></label>
                                        @error('priority_level')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-item form-float-style form-group">
                                <input name="effective_date_from" type="text" id="effective_date_from" autocomplete="off" value="" required class="datepicker" placeholder="YYYY-MM-DD">

                                <label for="effective_date_from">Effective Date From<span class="req-star"> *</span></label>
                                @error('effective_date_from')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-item form-float-style form-group">
                                <input name="effective_date_to" type="text" id="effective_date_to" autocomplete="off" value="" required class="datepicker" placeholder="YYYY-MM-DD">

                                <label for="effective_date_to">Effective Date To<span class="req-star">*</span></label>
                                @error('effective_date_to')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-floating form-float-style form-group required mb-3">
                                <div class="form-item form-float-style serach-rem mb-3">
                                    <div class="select top-space-rem after-drp form-float-style form-group">
                                        <select data-live-search="true" name="status" id="status" class="order-td-input selectpicker select-text height_drp is-valid select-validate" required>
                                            <option value="active" selected>Active</option>
                                            <option value="inactive">In-active</option>
                                        </select>
                                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">@lang('adminUser.status') <span class="text-red">*</span></label>
                                        @error('status')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-item form-float-style form-group">
                                <textarea name="notes" id="notes" autocomplete="off" value=""></textarea>

                                <label for="notes">Notes</label>
                                @error('notes')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>
                        </div>
                        <div class="col-md-6 discount">
                            <div class="cards-btn">
                                <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>
                                <a href="{{ route('hotel-recommendation.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
                            </div>
                        </div>
            </form>

        </div>
    </div>
    </div>
    </div>
    </div>
    </div>



    </div>
    <!-- /.row -->
    </div>
    <!-- End Row Div -->

    </div>

    <!-- End container fluid -->
</section>
@endsection

@section('js')

<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

<script>
    $(document).ready(function() {
        $('.airport_list').select2();

        // Initialize datepickers with correct format
        $(".datepicker").datepicker({
            dateFormat: "yy-mm-dd"
        });

        $('#basicForm').validate({
            rules: {
                "recommendation_type": {
                    required: true
                },
                "destination": {
                    required: true
                },
                // "logic_rule": {
                //     required: true
                // },
                "priority_level": {
                    required: true
                },
                "effective_date_from": {
                    required: true
                },
                "effective_date_to": {
                    required: true
                },
                "status": {
                    required: true
                }
            },
            messages: {
                "recommendation_type": {
                    required: "Please select Recommendation Type"
                },
                "destination": {
                    required: "Please select a Destination"
                },
                // "logic_rule": {
                //     required: "Please select a Logic Rule"
                // },
                "priority_level": {
                    required: "Please select a Priority Level"
                },
                "effective_date_from": {
                    required: "Please select a From Date"
                },
                "effective_date_to": {
                    required: "Please select a To Date"
                },
                "status": {
                    required: "Please select a Status"
                }
            },
            errorElement: 'span',
            errorPlacement: function(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight: function(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight: function(element) {
                $(element).removeClass('is-invalid');
            },
            submitHandler: function(form) {
                $("#disBtn").attr("disabled", true);
                form.submit();
            }
        });

        // Destination Dropdown
        $('#destination').select2({
            placeholder: "Select Destination",
            minimumInputLength: 0,
            ajax: {
                url: '/get-all-cities',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        q: params.term || '',
                        page: params.page || 1
                    };
                },
                processResults: function(data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.results,
                        pagination: {
                            more: data.pagination.more
                        }
                    };
                },
                cache: true
            }
        });

        $('#destination').on('select2:open', function() {
            let input = document.querySelector('.select2-container--open input.select2-search__field');
            if (input) input.dispatchEvent(new Event('input', {
                bubbles: true
            }));
        });

        // Hotels Dropdown
        $('#hotels').select2({
            placeholder: "Select Hotels",
            minimumInputLength: 0,
            ajax: {
                url: '/get-all-hotels',
                dataType: 'json',
                delay: 250,
                data: function(params) {
                    return {
                        q: params.term || '',
                        page: params.page || 1,
                        city: $('#destination').val()
                    };
                },
                processResults: function(data, params) {
                    params.page = params.page || 1;
                    return {
                        results: data.results,
                        pagination: {
                            more: data.pagination.more
                        }
                    };
                },
                cache: true
            }
        });


        $('#hotels').on('select2:open', function() {
            let input = document.querySelector('.select2-container--open input.select2-search__field');
            if (input) input.dispatchEvent(new Event('input', {
                bubbles: true
            }));
        });


        function toggleFields() {
            const selected = $('#recommendation_type').val();

            if (selected === 'general_logic') {
                $('#logic_rule').closest('.col-md-6').show();
                $('#hotels').closest('.col-md-6').hide();
            } else if (selected === 'manual_selection') {
                $('#logic_rule').closest('.col-md-6').hide();
                $('#hotels').closest('.col-md-6').show();
            }
        }

        // Run on page load
        toggleFields();

        // Run on change
        $('#recommendation_type').on('change', toggleFields);

    });
</script>


@append