@extends('admin.layout.main')


@section('content')
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.5/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/2.2.2/css/dataTables.dataTables.min.css">
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link href="
https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css
" rel="stylesheet">
<style>
    .dt-input {
        font-size: 14px;
        /* Optional: smaller label */
    }

    .dt-search input {
        width: 200px;
        height: 40px;
        padding: 3px 5px;
        font-size: 14px;
        border: 1px solid #ccc;
        border-radius: 4px;
    }

    div.dataTables_filter {
        text-align: right;
        margin-bottom: 10px;
    }

    div.dataTables_filter input {
        width: 200px !important;
        display: inline-block;
    }

    #log_filter_form .form-group {
        margin-bottom: 10px;
    }

    #log_filter_form .form-control {
        padding: 5px 10px;
    }

    #log_filter_form {
        margin-bottom: 15px;
    }

    #log_filter_form .card-footer {
        display: flex;
        justify-content: flex-end;
        gap: 10px;
    }

    .dataTables_wrapper .row {
        margin: 0;
    }

    .table thead th {
        white-space: nowrap;
        background-color: #343A40;
        color: white;
        text-align: center;
    }

    .table tbody tr td {
        font-size: 14px;
    }
</style>


<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-4 mt-2">
            <div class="col-sm-9 d-flex breadcrumb-style">
                <h1 class="m-0">Admin as Customer Login Logs</h1>
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
                    <li class="breadcrumb-item"><a href="#">Admin as Customer Login Logs</a></li>
                </ol>
            </div><!-- /.col -->

        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->


<section class="content">
    <div class="container-fluid">

        <div class="row">
            <div class="table-responsive">
                <table class="table table-bordered table-striped" id="adminLogs">

                    <thead>
                        <th>S.No</th>
                        <th>Login As</th>
                        <th>Log Name</th>
                        <th>Created By</th>
                        <th>Created At</th>
                    </thead>

                    <tbody>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
</section>

@endsection
@section('js')
<script src="https://code.jquery.com/jquery-3.7.1.js"></script>
<script src="https://cdn.datatables.net/2.2.2/js/dataTables.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script>
    $(document).ready(function() {
        var bookingTable = $('#adminLogs').DataTable({
            processing: true,
            serverSide: true,
            ajax: {
                url: '{{ route("admin.get-admin-as-customer-log") }}',
                method: 'GET',
            },
            columns: [{
                    data: 'DT_RowIndex',
                    name: 'DT_RowIndex',
                    title: 'S.No',
                    orderable: false,
                    searchable: false,
                },
                {
                    data: 'customer_name',
                    name: 'customer_name',
                },
                {
                    data: 'log_name',
                    name: 'log_name',
                },
                {
                    data: 'admin_name',
                    name: 'admin_name',
                },
                {
                    data: 'created_at',
                    name: 'created_at',
                    title: 'Login Date & Time'
                },
            ],
        });
    });
</script>
@endsection