  @extends('admin.booking.layouts.invoice_ar')
  @section('invoice_content_ar')

  @php

  if ($editedFlightDetails) {
  $editedBookingDetail = json_decode($editedFlightDetails->booking_details);

  $userDetails = $editedBookingDetail->userDetails;
  $flightDetails = $editedBookingDetail->flightDetails;
  $passengerDetails =$editedBookingDetail->passengerDetails;
  $paymentDetails = $editedBookingDetail->processedPrice;
  $segments =$flightDetails->airlines[0]->flights[0]->segments ?? [];
  }

  @endphp

        <table style="table-layout:fixed;">
          <tr>


            <td>
              <table>
                <tr dir="rtl">
                  <td>
                    <div class="col-md-6 guest mt-5 ">
                      <div class="cus_box">
                        <table class="table table-bordered table-sm">
                          <tbody class="book_details_sec">
                            <tr>
                              <td>{{ ' - '}}</td>
                            </tr>
                            <tr>
                              <td>{{ ' - '}}</td>
                            </tr>
                            <tr>
                              <td> {{ !empty($editedFlightDetails->booking_date) ? \Carbon\Carbon::parse($editedFlightDetails->booking_date)->format('Y-m-d') : ' - ' }}</td>
                            </tr>


                            <tr>
                              <td>
                                <div class="currency-alignment">
                                  <span>{{$paymentDetails->grandTotal ?? 0 }}</span>
                                  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}
                                </div>
                              </td>
                            </tr>


                          </tbody>
                        </table>
                      </div>
                    </div>
                  </td>
                  <td>
                    <div class="col-md-6 guest mt-5">
                      <div class="cus_box">
                        <table class="table table-bordered table-sm">
                          <tbody class="book_details_sec">
                            <tr>
                              <td class="txAlign_end"><strong>رقم تسجيل ضريبة القيمة المضافة:</strong></td>
                            </tr>
                            <tr>
                              <td class="txAlign_end"><strong>رقم الفاتورة:</strong></td>
                            </tr>
                            <tr>
                              <td class="txAlign_end"><strong>تاريخ الفاتورة:</strong></td>
                            </tr>
                            <tr>
                              <td class="txAlign_end"><strong>المبلغ الإجمالي المستحق:</strong></td>
                            </tr>

                          </tbody>
                        </table>
                      </div>
                    </div>

                  </td>



                </tr>
              </table>


            </td>



            <td dir="rtl">

              <div class="col-md-6 guest mt-5 d-flex justify-content-end" style="margin-top: 1.5rem !important;">


                <p class="mb-1">اسم الراكب الرئيسي</p>

                <p style="color: #005C8B;font-weight:bold; margin: 10px 0px">{{ $userDetails->title ?? '' }} {{ $editedFlightDetails->first_name ?? ' ' }} {{ $editedFlightDetails->last_name ?? ' ' }}</p>
                <p class="mb-1">معرف ريهلتي: {{ $bookingDetail->booking_ref ?? '' }}</p>


              </div>
            </td>



          </tr>
        </table>

        <div class="col-md-12">



          <table class="table mt-5 invoice_table" style="width: 100%;" dir="rtl">
            <thead>
              <tr class="tabletitle">
                <th style="text-align: right;">خدمة</th>
                <th style="text-align: right;">وصف</th>
                <th style="text-align: right;">اسم الراكب</th>
                <th style="text-align: right;">كمية</th>
                <th style="text-align: right;">رقم التذكرة</th>
                <th style="text-align:end;">كمية</th>
              </tr>
            </thead>
            <tbody>
              <tr class="no-border">
                <td class="text-left">
                  <p class="itemtext">#رحلة جوية</p>
                </td>
                <td class="text-left">
                  @if($segments && !empty($segments) && isset($segments))
                  @foreach($segments as $key => $value)
                  <p class="itemtext" style="margin-top: 3px;margin-bottom:3px">
                    # {{$value->airlineData->name ?? ''}} ({{$value->airlineData->code ?? ''}})
                  </p>
                  <p class="itemtext" style="margin-top: 3px;margin-bottom:3px">
                    # {{$value->departureAirportData->city_name}}, {{$value->departureAirportData->country_name}}, {{$value->departure->iataCode}}, {{str_replace("T"," ",$value->departure->at)}}<br>
                    # {{getCabinClass($value->segmentFare->cabin,'ar')}}
                  </p>
                  <p class="itemtext" style="margin-top: 3px;margin-bottom:3px">
                    # {{$value->arrivalAirportData->city_name}}, {{$value->arrivalAirportData->country_name}}, {{$value->arrival->iataCode}}, {{str_replace("T"," ",$value->arrival->at)}}<br>

                  </p>
                  <br>
                  <hr><br>
                  @endforeach
                  @else
                  <p> - </p>
                  <br>
                  <hr><br>


                  @endif


                </td>
                <td>

                  @if($passengerDetails && !empty($passengerDetails) && isset($passengerDetails))
                  @php $i = 0; @endphp
                  @foreach ($passengerDetails as $pkey => $pvalue)
                  <div style="display: flex; column-gap:5px; margin-bottom: 5px;">
                    <span style="font-weight: bold;">{{ ++$i }}.</span>
                    <span style="text-align: start;">{{ $pvalue->first_name ?? '' }} {{ $pvalue->last_name ?? '' }}</span>
                  </div>
                  @endforeach
                  @else
                  <div style="display: flex; column-gap:5px; margin-bottom: 5px;">
                    <span style="font-weight: bold;">1.</span>
                    <span style="text-align: start;"> - </span>
                  </div>

                  @endif


                </td>
                <td class="text-center">
                  <p class="itemtext"  style="text-align: right;">{{ $i ?? '-' }}</p>
                </td>
                <td class="text-center">
                  <p class="itemtext">{{ $bookingDetail->ticket_numbers ?? '-' }}</p>
                </td>
                <td style="text-align:end;">
                  <p class="itemtext">
                    {{ $paymentDetails->basePriceRemovedVAT }}
                    {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}
                  <p>
                </td>
              </tr>

            </tbody>

          </table>

          <table dir="rtl">

            <tfoot>
              <!-- Total Row -->
              <tr class="no-border">
                <td colspan="4" class="fBold">المجموع الإجمالي:</td>
                <td class="tx_center" style=" text-align:end">المجموع الفرعي</td>
                <td class="txAlign_end">
                  {{ $paymentDetails->basePriceRemovedVAT}}
                  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}
                </td>
              </tr>

              <!-- VAT Row -->
              <tr class="no-border">
                <td colspan="4" class="fBold">{{ amountToWord($paymentDetails->grandTotal ?? 0, $paymentDetails->currency , 'ar' )}}</td>
                <td class="tx_center" style=" text-align:end">الضرائب الأخرى</td>
                <td class="txAlign_end">{{ ($paymentDetails->totalTaxAmount ?? 0) }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>
              </tr>

              <!-- Service Fee Row -->
              <tr class="no-border">
                <td colspan="4"></td>
                <td class="tx_center" style=" text-align:end">ضريبة القيمة المضافة {{$paymentDetails->vat ?? ''}} % + رسوم الخدمة</td>
                <td class="txAlign_end">
                  {{ $paymentDetails->markupServiceFee ?? 0}}
                  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}
                </td>

              </tr>

              @if(isset($paymentDetails->isAddOnUsed) && $paymentDetails->isAddOnUsed)
              <tr class="no-border">
                <td colspan="4"></td>
                <td class="txAlign_end">المبلغ الإضافي</td>
                <td class="txAlign_end">{{ $paymentDetails->addOnAmount ?? 0  }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>
              </tr>
              @endif
              @if(isset($paymentDetails->isCouponUsed) && $paymentDetails->isCouponUsed)
              <tr class="no-border">
                <td colspan="4"></td>
                <td class="txAlign_end">مبلغ القسيمة</td>
                <td class="txAlign_end">( - ) {{ $paymentDetails->couponAmount ?? 0  }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>
              </tr>
              @endif
              @if(isset($paymentDetails->isRedeemUsed) && $paymentDetails->isRedeemUsed)
              <tr class="no-border">
                <td colspan="4"></td>
                <td class="txAlign_end">استرداد المبلغ</td>
                <td class="txAlign_end">( - ) {{ $paymentDetails->redeemAmount ?? 0  }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>
              </tr>
              @endif
              @if(isset($paymentDetails->isWalletUsed) && $paymentDetails->isWalletUsed)
              <tr class="no-border">
                <td colspan="4"></td>
                <td class="txAlign_end">مبلغ المحفظة</td>
                <td class="txAlign_end">( - ) {{ $paymentDetails->walletAmount ?? 0 }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>
              </tr>
              @endif
              @if(isset($paymentDetails->isSeatUsed) && $paymentDetails->isSeatUsed)
              <tr class="no-border">
                <td colspan="4"></td>
                <td class="txAlign_end">عدد المقاعد المختارة</td>
                <td class="txAlign_end">{{ $paymentDetails->selectedSeatsTotalPrice?? 0  }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>
              </tr>
              @endif
              @if(isset($paymentDetails->isBagUsed) && $paymentDetails->isBagUsed)
              <tr class="no-border">
                <td colspan="4"></td>
                <td class="txAlign_end">كمية الأمتعة</td>
                <td class="txAlign_end">{{ $paymentDetails->bagAmount?? 0  }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>
              </tr>
              @endif

              <!-- Grand Total Row -->
              <tr class="no-border bg-gry">
                <td colspan="4"></td>
                <td style="font-weight:bold;color:#000;background: #edf1fe;border-radius: 1px; text-align:end">المجموع الإجمالي</td>
                <td class="txAlign_end" style="font-weight:bold;color:#000;background: #edf1fe;border-radius: 1px;">
                  {{ $paymentDetails->grandTotal ?? 0 }}
                  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}
                </td>
              </tr>
            </tfoot>
          </table>


          <!-- End of Table Invoice Content -->
@endsection