@extends('admin.booking.layouts.invoice_en')
@section('invoice_content_en')
@php
if ($editedFlightDetails) {
$editedBookingDetail = json_decode($editedFlightDetails->booking_details);

$userDetails = $editedBookingDetail->userDetails;
$flightDetails = $editedBookingDetail->flightDetails;
$passengerDetails = $editedBookingDetail->passengerDetails;
$paymentDetails = $editedBookingDetail->processedPrice;
$segments = $flightDetails->airlines[0]->flights[0]->segments ?? [];
}
@endphp

      <table style="table-layout:fixed;">
        <tr>

          <td>
            <div class="col-md-6 guest mt-5" style="margin-top: 1.5rem !important;">


              @if($passengerDetails && !empty($passengerDetails) && isset($passengerDetails))

              <p class="mb-1">Lead Passenger Name</p>
              <?php $passengerCount = 0;
              foreach ($passengerDetails as $pkey => $pvalue) {
                $passengerCount++; ?>
                <h2 class="mb-1 mt-5" style="font-size: 30px;">{{ucfirst($pvalue->title ?? '') }} {{ucfirst($pvalue->first_name ?? '')}} {{ucfirst($pvalue->second_name ?? '')}}{{ucfirst($pvalue->last_name ?? '')}} </h2>
                <p class="mb-1" style="margin-top:10px; ">Rehlte ID: {{ $bookingDetail->booking_ref ?? '' }}</p>

              <?php break;
              } ?>

              @else
              <p class="mb-1">Lead Passenger Name</p>

              <h2 class="mb-1 mt-5">N/A</h2>

              <p class="mb-1" style="margin-top:10px; ">Rehlte ID: {{ $bookingDetail->booking_ref ?? '' }}</p>
              @endif




            </div>
          </td>
          <td>


            <table>
              <tr>
                <td>
                  <div class="col-md-6 guest mt-5">
                    <div class="cus_box">
                      <table class="table table-bordered table-sm">
                        <tbody class="book_details_sec">
                          <tr>
                            <td class="txAlign_end"><strong>VAT Reg.No:</strong></td>
                          </tr>
                          <tr>
                            <td class="txAlign_end"><strong>Rehlte Invoice No:</strong></td>
                          </tr>
                          <tr>
                            <td class="txAlign_end"><strong>Invoice Date:</strong></td>
                          </tr>
                          <tr>
                            <td class="txAlign_end"><strong>Total Amount Due:</strong></td>
                          </tr>

                        </tbody>
                      </table>
                    </div>
                  </div>

                </td>
                <td>
                  <div class="col-md-6 guest mt-5">
                    <div class="cus_box">
                      <table class="table table-bordered table-sm">
                        <tbody class="book_details_sec">
                          <tr>
                            <td class="txAlign_end">{{ 'N/A'}}</td>
                          </tr>
                          <tr>
                            <td class="txAlign_end">{{ 'N/A'}}</td>
                          </tr>
                          <tr>
                            <td class="txAlign_end"> {{ !empty($editedFlightDetails->booking_date) ? \Carbon\Carbon::parse($editedFlightDetails->booking_date)->format('d-m-Y') : ' - ' }}</td>
                          </tr>
                          <tr>
                            <td class="txAlign_end">  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->grandTotal ?? 0 }}</td>
                          </tr>
                        </tbody>
                      </table>
                    </div>
                  </div>
                </td>


              </tr>
            </table>


          </td>



        </tr>
      </table>

      <div class="col-md-12">



        <table class="table mt-5 invoice_table" style="width: 100%;">
          <thead>
            <tr class="tabletitle">
              <th class="text-left">Service</th>
              <th class="text-left">Description</th>
              <th class="text-center">Passenger Name</th>
              <th class="text-center">Quantity</th>
              <th class="text-center">Ticket No.</th>
              <th style="text-align:end;">Amount</th>
            </tr>
          </thead>
          <tbody>
            <tr class="no-border">
              <td class="text-left">
                <p class="itemtext">#Flight</p>
              </td>
              <td class="text-left">
                @if($segments && !empty($segments) && isset($segments))
                @foreach($segments as $key => $value)
                <p class="itemtext" style="margin-top: 3px;margin-bottom:3px">
                  #{{$value->airlineData->name ?? ''}} ({{$value->airlineData->code ?? ''}})
                </p>
                <p class="itemtext" style="margin-top: 3px;margin-bottom:3px">
                  #{{$value->departureAirportData->city_name}}, {{$value->departureAirportData->country_name}}, {{$value->departure->iataCode}}, {{str_replace("T"," ",$value->departure->at)}}<br>
                  #{{$value->segmentFare->cabin}}
                </p>
                <p class="itemtext" style="margin-top: 3px;margin-bottom:3px">
                  #{{$value->arrivalAirportData->city_name}}, {{$value->arrivalAirportData->country_name}}, {{$value->arrival->iataCode}}, {{str_replace("T"," ",$value->arrival->at)}}<br>

                </p>
                <br>
                <hr><br>
                @endforeach
                @else
                <p>N/A</p>
                <br>
                <hr><br>


                @endif


              </td>
              <td>

                @if($passengerDetails && !empty($passengerDetails) && isset($passengerDetails))
                @php $i = 0; @endphp
                @foreach ($passengerDetails as $pkey => $pvalue)
                <div style="display: flex; column-gap:5px; margin-bottom: 5px;">
                  <span style="font-weight: bold;">{{ ++$i }}.</span>
                  <span style="text-align: start;">{{ $pvalue->first_name ?? '' }} {{ $pvalue->last_name ?? '' }}</span>
                </div>
                @endforeach
                @else
                <div style="display: flex; column-gap:5px; margin-bottom: 5px;">
                  <span style="font-weight: bold;">1.</span>
                  <span style="text-align: start;">N/A</span>
                </div>

                @endif


              </td>
              <td class="text-center">
                <p class="itemtext">{{ $passengerCount ?? 'N/A' }}</p>
              </td>
              <td class="text-center">
                <p class="itemtext">{{ $bookingDetail->ticket_numbers ?? 'N/A' }}</p>
              </td>
              <td style="text-align:end;">
                <p class="itemtext"> {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->basePriceRemovedVAT }}</p>
              </td>
            </tr>

          </tbody>

        </table>

        <table>

          <tfoot>
            <!-- Total Row -->
            <tr class="no-border">
              <td colspan="4" class="fBold">Grand Total:</td>
              <td class="tx_center" style=" text-align:end">Subtotal</td>
              <td class="txAlign_end"> {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->basePriceRemovedVAT}}</td>
            </tr>

            <!-- VAT Row -->
            <tr class="no-border">
              <td colspan="4" class="fBold">{{ amountToWord($paymentDetails->grandTotal ?? 0, $paymentDetails->currency) }}</td>
              <td class="tx_center" style=" text-align:end">Other Taxes</td>
              <td class="txAlign_end"> {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ ($paymentDetails->totalTaxAmount ?? 0) }}</td>
            </tr>

            <!-- Service Fee Row -->
            <tr class="no-border">
              <td colspan="4"></td>
              <td class="tx_center" style=" text-align:end">VAT {{$paymentDetails->vat ?? ''}} % + Service Fee</td>
              <td class="txAlign_end">
                 {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}
                {{ $paymentDetails->markupServiceFee ?? 0}}
              </td>

            </tr>

            @if(isset($paymentDetails->isAddOnUsed) && $paymentDetails->isAddOnUsed)
            <tr class="no-border">
              <td colspan="4"></td>
              <td class="txAlign_end">Addon Amount</td>
              <td class="txAlign_end"> {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->addOnAmount ?? 0  }}</td>
            </tr>
            @endif
            @if(isset($paymentDetails->isCouponUsed) && $paymentDetails->isCouponUsed)
            <tr class="no-border">
              <td colspan="4"></td>
              <td class="txAlign_end">Coupon Amount</td>
              <td class="txAlign_end">( - )  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->couponAmount ?? 0  }}</td>
            </tr>
            @endif
            @if(isset($paymentDetails->isRedeemUsed) && $paymentDetails->isRedeemUsed)
            <tr class="no-border">
              <td colspan="4"></td>
              <td class="txAlign_end">Redeem Amount</td>
              <td class="txAlign_end">( - )  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->redeemAmount ?? 0  }}</td>
            </tr>
            @endif
            @if(isset($paymentDetails->isWalletUsed) && $paymentDetails->isWalletUsed)
            <tr class="no-border">
              <td colspan="4"></td>
              <td class="txAlign_end">Wallet Amount</td>
              <td class="txAlign_end">( - )  {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->walletAmount ?? 0 }}</td>
            </tr>
            @endif
            @if(isset($paymentDetails->isSeatUsed) && $paymentDetails->isSeatUsed)
            <tr class="no-border">
              <td colspan="4"></td>
              <td class="txAlign_end">Selected Seats Amount</td>
              <td class="txAlign_end"> {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->selectedSeatsTotalPrice?? 0  }}</td>
            </tr>
            @endif
            @if(isset($paymentDetails->isBagUsed) && $paymentDetails->isBagUsed)
            <tr class="no-border">
              <td colspan="4"></td>
              <td class="txAlign_end">Baggage Amount</td>
              <td class="txAlign_end"> {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->bagAmount?? 0  }}</td>
            </tr>
            @endif

            <!-- Grand Total Row -->
            <tr class="no-border bg-gry">
              <td colspan="4"></td>
              <td style="font-weight:bold;color:#000;background: #edf1fe;border-radius: 1px; text-align:end">Grand Total</td>
              <td class="txAlign_end" style="font-weight:bold;color:#000;background: #edf1fe;border-radius: 1px;">
                {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} {{ $paymentDetails->grandTotal ?? 0 }}
              </td>
            </tr>
          </tfoot>
        </table>


        <!-- End of Table Invoice Content -->





      </div>

      <table>
        <tr>
          <div class="col-md-12">

            <div class="row mb-5">

              <td></td>
              <td></td>
              <td></td>

              <td>


              </td>

              <td>
                <img src="{{ URL::asset('assets/images/footerlogo.png') }}" alt="Logo">
              </td>


              <td>
              </td>



            </div>

          </div>
        </tr>
      </table>

      <table>
        <tr>
          <td></td>
          <td></td>
          <td></td>
          <td>
            <div class="qr-footer">
              <img src="{{ URL::asset('assets/images/qr.png') }}" alt="Logo">
            </div>
          </td>
        </tr>
      </table>

    </div><!--End InvoiceTop-->
@endsection