@extends('admin.booking.layouts.invoice_ar', ['invoiceSettings' => $invoiceSettings])
@section('invoice_content_ar')
<?php

if ($editedHotelDetails) {
  $editedBookingDetail = json_decode($editedHotelDetails->booking_details);
  $userDetails = $editedBookingDetail->userDetails;
  $searchDetails = $editedBookingDetail->searchDetails;
  $hotelDetails = $editedBookingDetail->hotelDetails;
  $paymentDetails = $editedBookingDetail->processedPrice;

  $checkoutdate = strtotime($searchDetails->checkOutDate  ?? 0);
  $checkindate = strtotime($searchDetails->checkInDate ?? 0);
  $datediff = $checkoutdate - $checkindate;

  $numberofdays =  round($datediff / (60 * 60 * 24));
  $adult = 0;
  $child = 0;
  $room = 0;
  $roomtype = "";
  $boardName = "";
  $rateCommment = "";
  $childAges = "";

  $occupancyD = $searchDetails->occupancies ?? '';


  $adult = $occupancyD[0]->adults ?? 0;
  $child = $occupancyD[0]->children ?? 0;
  $hotel_image = $hotelDetails->hotelDetails->Photos[0] ?? '';
}


?>




<table style="table-layout:fixed;" dir="rtl">
  <tr style="border-top: 1px solid #000 !important;">

    <td>
      <div class="col-md-6 guest mt-5" style="margin-top: 1.5rem !important;">

        <p class="mb-1" style="margin-bottom:10px;">اسم الضيف</p>
        <h2 style="font-size: 30px;">
          {{ ucwords($userDetails->title ?? '') }} {{$userDetails->firstName ?? ''  }} &nbsp;{{ $userDetails->lastName ?? ''}}
        </h2>
        <p class="mb-1" style="margin-top:10px; ">معرف ريهلتي: {{ $bookingDetail->booking_ref ?? '' }}</p>

      </div>
    </td>

    <td>


      <table>
        <tr>
          <td>
            <div class="col-md-6 guest mt-5">
              <div class="cus_box">
                <table class="table table-bordered table-sm">
                  <tbody class="book_details_sec">

                    <tr>
                      <td class="txAlign_end"><strong>رقم تسجيل ضريبة القيمة المضافة:</strong></td>
                    </tr>
                    <tr>
                      <td class="txAlign_end"><strong>رقم الفاتورة:</strong></td>
                    </tr>
                    <tr>
                      <td class="txAlign_end"><strong>تاريخ الفاتورة:</strong></td>
                    </tr>
                    <tr>
                      <td class="txAlign_end"><strong>المبلغ الإجمالي المستحق:</strong></td>
                    </tr>

                  </tbody>
                </table>
              </div>
            </div>

          </td>

          <td>
            <div class="col-md-6 guest mt-5">
              <div class="cus_box">
                <table class="table table-bordered table-sm">
                  <tbody class="book_details_sec">

                    <tr>
                      <td>{{ ' - '}}</td>
                    </tr>
                    <tr>
                      <td>{{ ' - ' }}</td>
                    </tr>
                    <tr>
                      <td> {{ !empty($editedHotelDetails->booking_date) ? \Carbon\Carbon::parse($editedHotelDetails->booking_date)->format('Y-m-d') : '-' }}</td>
                    </tr>
                    <tr>
                      <td>
                        <div class="currency-alignment">
                          <span>{{$paymentDetails->grandTotal ?? 0 }}</span>
                          {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}
                        </div>
                      </td>
                    </tr>
                  </tbody>
                </table>
              </div>
            </div>
          </td>


        </tr>
      </table>


    </td>



  </tr>
</table>

<div class="col-md-12">





  <!--  -->

  <table class="table mt-5 invoice_table" style="width: 100%;" dir="rtl">
    <thead>
      <tr class="tabletitle">
        <th style="text-align: right;">خدمة</th>
        <th style="text-align: right;">وصف</th>
        <th style="text-align: right;">كمية</th>
        <th style="text-align:end;">كمية</th>
      </tr>
    </thead>
    <tbody>
      <tr class="no-border" style="border-bottom:1px solid #000;">
        <td class="text-left">
          <p class="itemtext" style="text-align: right;"># الفندق</p>
        </td>
        <td class="text-left">
          <p class="itemtext" style="text-align: right;" style="color:#000;font-weight:bold;">{{ $hotelDetails->hotelDetails->DisplayName ?? '' }} </p>

          <p class="itemtext" style="text-align: right;"># البالغين : {{ $adult ?? ''   }}</p>
          <p class="itemtext" style="text-align: right;"># أطفال : {{ $child ?? ''  }}</p>
          <p class="itemtext" style="text-align: right;">
            # الدفع :
            {{ !empty($searchDetails->stay->checkIn) ? \Carbon\Carbon::parse($searchDetails->stay->checkOut)->format('Y-m-d') : '' }}
          </p>

          <p class="itemtext" style="text-align: right;">
            # الدفع :
            {{ !empty($searchDetails->stay->checkOut) ? \Carbon\Carbon::parse($searchDetails->stay->checkOut)->format('Y-m-d') : '' }}
          </p>

          <p class="itemtext" style="text-align: right;">{{$hotelDetails->selectedRooms->RoomType ?? 'N/A' }} - {{ $hotelDetails->selectedRooms->RoomName ?? 'N/A' }} - {{ $hotelDetails->selectedRooms->RoomClass ?? 'N/A' }}</p>
        </td>

        <td class="text-center">
          <p class="itemtext" style="text-align: right;"> {{ $adult+$child }} </p>
        </td>
        <td style="text-align:end;">

          <p class="itemtext">{{ $paymentDetails->totalPrice ?? 0}}{!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} </p>
        </td>
      </tr>

    </tbody>
    <tfoot>

      <tr class="no-border">

        <td colspan="2" class="fBold">إجمالي المنحة:</td>
        <td class="txAlign_end">المجموع الفرعي</td>
        <td class="txAlign_end">{{ $paymentDetails->totalPrice ?? 0}} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} </td>
      </tr>

      <tr class="no-border">

        <td colspan="2" class="fBold">{{ amountToWord($paymentDetails->grandTotal ?? 0,  $paymentDetails->currency, 'ar')  }}</td>
        <td class="txAlign_end">رسوم الخدمة </td>
        <td class="txAlign_end">{{ $paymentDetails->markupServiceFee ?? 0 }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!}</td>


      </tr>


      @if(isset($paymentDetails->isAddOnUsed) && $paymentDetails->isAddOnUsed)
      <tr class="no-border">
        <td colspan="2"></td>
        <td class="txAlign_end">المبلغ الإضافي</td>
        <td class="txAlign_end">{{ $paymentDetails->addOnAmount ?? 0 }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} </td>
      </tr>
      @endif
      @if(isset($paymentDetails->isCouponUsed) && $paymentDetails->isCouponUsed)
      <tr class="no-border">
        <td colspan="2"></td>
        <td class="txAlign_end">مبلغ القسيمة</td>
        <td class="txAlign_end">( - ) {{ $paymentDetails->couponAmount ?? 0  }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} </td>
      </tr>
      @endif
      @if(isset($paymentDetails->isRedeemUsed) && $paymentDetails->isRedeemUsed)
      <tr class="no-border">
        <td colspan="2"></td>
        <td class="txAlign_end">استرداد المبلغ</td>
        <td class="txAlign_end">( - ) {{ $paymentDetails->redeemAmount ?? 0  }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} </td>
      </tr>
      @endif
      @if(isset($paymentDetails->isWalletUsed) && $paymentDetails->isWalletUsed)
      <tr class="no-border">
        <td colspan="2"></td>
        <td class="txAlign_end">مبلغ المحفظة</td>
        <td class="txAlign_end">( - ) {{ $paymentDetails->walletAmount ?? 0 }}{!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} </td>
      </tr>
      @endif

      <tr class="no-border bg-gry">
        <td colspan="2"></td>
        <td class="txAlign_end" style="font-weight:bold;color:#000;background: #edf1fe;border-radius: 1px;">المجموع الإجمالي </td>
        <td class="txAlign_end" style="font-weight:bold;color:#000;background: #edf1fe;border-radius: 1px;">{{ $paymentDetails->grandTotal ?? 0 }} {!! getCurrencyImage($paymentDetails->currency ?? '﷼') !!} </td>
      </tr>



    </tfoot>
  </table>

  <!-- End of Table Invoice Content -->
  @endsection