<html lang="en">

<head>
  <meta charset="UTF-8">
  <title>Rehlte Flight Ticket</title>
  @include('admin.booking.includes.styles.ticket')
</head>

<body translate="no">


  @php

  if ($editedFlightDetails) {
  $editedFlightDetails = json_decode($editedFlightDetails);
  $editedBookingDetails = json_decode($editedFlightDetails[0]->booking_details);
  $userDetails = $editedBookingDetails->booking_details->userDetails ?? $editedBookingDetails->userDetails;
  $flightDetails = $editedBookingDetails->booking_details->flightDetails->airlines[0]->flights ?? $editedBookingDetails->flightDetails->airlines[0]->flights;
  $editedflightInfo = $editedBookingDetails->booking_details->flightDetails->airlines ?? $editedBookingDetails->flightDetails->airlines;

  $passengerDetails = $editedBookingDetails->booking_details->passengerDetails ?? $editedBookingDetails->passengerDetails;

  $paymentDetails = $editedBookingDetails->booking_details->processedPrice ?? $editedBookingDetails->processedPrice;
  $segments = $flightDetails[0]->segments ?? '';

  $bookingDetails = json_decode($bookingDetail->booking_details);

  $additionalBookingData = $additionalBookingDetails;

  $additionalBookingDetails = json_decode($additionalBookingDetails->booking_details ?? '{}');

  $seatDetails = $bookingDetails->booking_details->flightDetails->seatDetails->seatDetails ?? ($additionalBookingDetails->flightDetails->seatDetails ?? '');



  $originalFlightDetails = $bookingDetails->booking_details->flightDetails ?? ($additionalBookingDetails->flightDetails ?? '');


  $originalFlightInfo = $originalFlightDetails->airlines ?? [];

  $brandedFares = $bookingDetails->booking_details->flightDetails->brandedFaresBySegment ?? ($additionalBookingDetails->flightDetails->brandedFaresBySegment ?? '');

  $bagDetails = array($bookingDetails->booking_details->flightDetails->additionalDetails->addBags ?? '') ?? ($additionalBookingDetails->flightDetails->additionalDetails->addBags ?? '');


  // Additional Booking Details Response for GDS and Airline PNR Details
  $serviceProviderResponse = json_decode($additionalBookingData->service_provider_booking_response ?? '{}', true);

  $airlinePnr = $gdsPnr = [];

  if (!empty($serviceProviderResponse) && isset($serviceProviderResponse['data']['associatedRecords'])) {
  $associatedRecords = $serviceProviderResponse['data']['associatedRecords'];
  foreach ($associatedRecords as $record) {
  if ($record['originSystemCode'] === 'GDS') {
  $gdsPnr[] = $record['reference'];
  } else {
  $airlinePnr[] = $record['reference'];
  }
  }
  }
  $searchDetails = $editedBookingDetails->booking_details->searchDetails ?? ($editedBookingDetails->searchDetails ?? []);


  $airlineList = $searchDetails->airlineList ?? [];

  }

  @endphp

  <div class="ticket-frame">

    <div id="headerimage"></div>
    <div id="invoice">

      <div id="invoice-top" class="row">
        <!-- Logo Section -->

        <table style="table-layout:auto !important;">
          <tr>
            <td style="width: 180px !important;">
              <div class="col-md-3">
                <div class="logo">

                  @if($invoiceSettings && $invoiceSettings->logo_en)
                  <img src="{{ asset('storage/'.$invoiceSettings->logo_en) }}" alt="Logo">
                  @else
                  <img src="{{ URL::asset('assets/images/rehtle_logo.png') }}" alt="Logo">
                  @endif

                </div>
              </div>
            </td>

            <td style="text-align: left;">
              <div class="col-md-5">
                <div class="info">
                  <h2 class="mb-1 fs-5">{{ $invoiceSettings->title_en ?? 'Rehlte For Tourism LLC' }}</h2>

                  <p><strong>Address:</strong> {{ $invoiceSettings->address_en ?? 'Abu Bakr Siddiq Road, Al Nahdah District, Buraydah, Saudi Arabia 52389' }}</p>
                  <p><strong>Country:</strong> {{ $invoiceSettings->city_en ?? 'KSA'  }}</p>
                  <p><strong>Email:</strong>{{ $invoiceSettings->email ?? 'support@rehlte.com' }}</p>
                </div>
              </div>
            </td>

            <td>
              <div class="col-md-4">
                <div class="title">
                  <h1 class="first">Flight</h1>
                  <h1 class="second">Ticket</h1>
                </div>
              </div>
            </td>
          </tr>
        </table>

        @php
        $flightIcon = <<<SVG
          <svg width="30" height="30" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
          <g>
            <path d="M1.42329 9.99997L0.71754 7.54037C0.66369 7.35832 0.69239 7.1923 0.80364 7.0423C0.91489 6.8923 1.06214 6.8173 1.24539 6.8173C1.40244 6.8173 1.52955 6.83706 1.62671 6.87657C1.72388 6.91607 1.79837 6.96875 1.85019 7.0346L3.13481 8.7596L8.79829 8.7596L6.62906 1.44615C6.56496 1.2 6.60355 0.980775 6.74482 0.788475C6.88608 0.596158 7.08514 0.499999 7.34199 0.499999C7.53464 0.499999 7.69347 0.530449 7.81847 0.591349C7.94345 0.652249 8.03799 0.741675 8.10209 0.859625L12.779 8.7596L18.2694 8.7596C18.6139 8.7596 18.9068 8.88036 19.148 9.12188C19.3892 9.36339 19.5098 9.65666 19.5098 10.0017C19.5098 10.3467 19.3892 10.6394 19.148 10.8798C18.9068 11.1202 18.6139 11.2404 18.2694 11.2404L12.779 11.2404L8.10209 19.1403C8.03799 19.2583 7.94276 19.3477 7.81639 19.4086C7.69002 19.4695 7.53206 19.5 7.34251 19.5C7.0855 19.5 6.88631 19.4038 6.74494 19.2115C6.60359 19.0192 6.56496 18.8 6.62906 18.5538L8.79829 11.2404L3.13481 11.2404L1.85019 12.9654C1.79834 13.0312 1.72381 13.0839 1.62659 13.1234C1.52937 13.1629 1.40299 13.1827 1.24744 13.1827C1.06596 13.1827 0.918806 13.1076 0.80599 12.9577C0.693174 12.8077 0.66369 12.6416 0.71754 12.4596L1.42329 9.99997Z" fill="#CC0000" />
          </g>
          </svg>
          SVG;
          @endphp

          <table style="table-layout:fixed;">
            <tr>

              <td>
                <div class="col-md-6 guest mt-5" style="margin-top: 1.5rem !important;">

                  <button class="round-btn" style="border: none;">{{ ucwords($bookingDetail->additional_details ?? '')}}</button>
                  @php
                  $segmentsCollection = collect($segments);
                  $firstSegment = $segmentsCollection->first();
                  $lastSegment = $segmentsCollection->last();


                  @endphp
                  <h1 style="color: #005C8B; font-size: 2.5em;">{{$firstSegment->departureAirportData->city_name ?? getCityNameByAirportCode($firstSegment->departureAirportData->code) ?? ' '}}
                    {!! $flightIcon !!}
                    {{$lastSegment->arrivalAirportData->city_name ?? getCityNameByAirportCode($lastSegment->arrivalAirportData->code) ?? ' '}}</h3>

                    @php
                    if ($bookingDetail->booking_status == 'processing') {
                    $style = '#09496D';
                    } elseif ($bookingDetail->booking_status == 'confirmed') {
                    $style = 'green';
                    } elseif ($bookingDetail->booking_status == 'cancelled' || $bookingDetail->booking_status == 'failed') {
                    $style = 'red';
                    }
                    else{
                    $style = 'orange';
                    }

                    @endphp


                    <h2 class="text-margin" style="color: #005C8B;">
                      Booking Ticket: {{ $bookingDetail->booking_type }}:
                      <button
                        style="
                          background-color: {{ $style ?? 'orange' }};
                          color: white;
                          border-radius: 10px;
                          border: 1px solid {{ $style ?? 'orange' }};
                          padding: 6px;
                          outline: none;
                      ">
                        {{ !empty($bookingDetail->booking_status) ? ucwords($bookingDetail->booking_status) : '' }}
                      </button>
                    </h2>


                    <h3 class="text-margin">Booking ID / Rehlte ID: {{ $bookingDetail->booking_ref ?? ''}}</h3>
                    <h3 class="text-margin">
                      Airline Reference (PNR):
                      {{
                        !empty($airlinePnr) 
                          ? implode(',', $airlinePnr) 
                          : (!empty($gdsPnr) ? implode(',', $gdsPnr) : '') 
                      }}
                    </h3>

                    @if ($bookingDetail?->customer_language_code == App\Enums\Locale::English->value)
                    <h3 class="text-margin">Booking Date: {{\Carbon\Carbon::parse($bookingDetail->created_at)->format('d-m-Y') ?? ''}} </h3>
                    @else
                    <h3 class="text-margin">Booking Date: {{Carbon\Carbon::parse($bookingDetail->created_at)->format('Y-m-d') ?? ''}} </h3>
                    @endif

                </div>
              </td>


              <!-- <td></td> -->
              <td>



              </td>



            </tr>
          </table>


          <table>
            <tr>
              <td>
                <h3 style="color: #005C8B; font-size: 1.5em; font-weight:bold">Departure from {{$firstSegment->departureAirportData->city_name ?? getCityNameByAirportCode($firstSegment->departureAirportData->code)  ?? ' ' }} to {{$lastSegment->arrivalAirportData->city_name ?? getCityNameByAirportCode($lastSegment->arrivalAirportData->code) ?? ' ' }}</h3>
              </td>
              <td>


                <h3 style="color:black; font-size: 1.3em; text-align:end">Class: {{$flightDetails[0]->segments[0]->segmentFare->cabin ?? ''}}</h3>
              </td>

            </tr>

          </table>

          <hr style="border: 1px solid black; margin: 20px 0;">


          @if($editedFlightDetails && !empty($editedFlightDetails->flight_details))

          <table style="width: 100%; font-family: Arial, sans-serif; border-collapse: collapse; margin-bottom: 20px;">
            <!-- Departure Flight -->
            <tr>
              <td colspan="1" style="background-color: #005C8B; color: white; padding: 10px; text-align: left; font-weight: bold; border-radius:10px">
                Departure Flight
              </td>
            </tr>
            <tr>
              @php
              $departureTime = str_replace("T", " ", $segments->departure->at);
              $arrivalTime = str_replace("T", " ", $segments->arrival->at);

              $departure = new \DateTime($departureTime);
              $arrival = new \DateTime($arrivalTime);

              $interval = $departure->diff($arrival);

              $formattedDeparture = $departure->format('D d M') ?? ' ';
              $formattedArrival = $arrival->format('D d M') ?? ' ';

              @endphp

              @if($segments->numberOfStops == 0)
              @php
              $numberOfStops = 'Non-Stop';
              @endphp



              @endif
              <td style="width: 15%; text-align: center; vertical-align: middle; padding: 10px;">
                <img src="{{ isset($segments->airlineData) ? $segments->airlineData->logo: '' }}" alt="{{ isset($segments->airlineData) ? $segments->airlineData->name: '' }}" style="width: 60px; height: auto;">
                <div style="margin-top: 5px; font-size: 0.9em;">
                  {{ isset($segments->airlineData) && isset($segments->airlineData->name) ? $segments->airlineData->name : ' ' }}<br>
                  {{ isset($segments->aircraftData) && isset($segments->aircraftData->name) ? $segments->aircraftData->name : ' ' }}<br>
                  Flight: {{ $segments->carrierCode ?? ' ' }}, {{ isset($segments->aircraft) && isset($segments->aircraft->code) ? $segments->aircraft->code : ' ' }}
                </div>


              </td>
              <td style="width: 25%; text-align: left; padding: 10px;">
                <div style="font-size: 1.5em; font-weight: bold;">{{ date('H:i', strtotime(str_replace("T", " ", $segments->departure->at))) }}
                </div>
                <div style="font-size: 0.9em;"><i class="fas fa-sun" style="color: orange;"></i>
                  {{$segments->departure->iataCode}}<br>{{$segments->departureAirportData->city_name ?? (getCityNameByAirportCode($segments->departureAirportData->code) ?? '') }},{{$segments->departureAirportData->country_name ?? ''}}<br>{{$formattedDeparture}}<br>Terminal {{$segments->departure->terminal ?? ' '}}
                </div>
              </td>


              <td style="width: 10%; text-align: center; vertical-align: middle; padding: 10px;">
                <i class="fas fa-plane" style="color: #005C8B; font-size: 1.5em; transform: rotate(0deg);"></i>
                <div style="font-size: 0.9em; margin-top: 5px;">{{ $interval->format('%h hours %i minutes') }}<br>{{ $numberOfStops }}</div>
              </td>
              <td style="width: 25%; text-align: left; padding: 10px;">
                <div style="font-size: 1.5em; font-weight: bold;">{{ date('H:i', strtotime(str_replace("T", " ", $segments->arrival->at))) }}
                </div>
                <div style="font-size: 0.9em;"><i class="fas fa-sun" style="color: orange;"></i> {{$segments->arrival->iataCode}}<br>{{$segments->arrivalAirportData->city_name ?? (getCityNameByAirportCode($segments->arrivalAirportData->code) ?? '')}},{{$segments->arrivalAirportData->country_name ?? ' '}}<br>{{$formattedArrival}}<br>Terminal {{$segments->arrival->terminal ?? ' '}}</div>
              </td>
            </tr>



          </table>


          @else
          @php $i = 0; @endphp

          @foreach ($editedflightInfo as $airline)
          @foreach ($airline->flights ?? [] as $flight)
          @php
          $segments = $flight->segments ?? [];
          $numberOfStops = count($segments) - 1;

          $firstSegment = $segments[0] ?? null;
          $lastSegment = $segments[$numberOfStops] ?? null;

          $departureDateTime = $firstSegment ? new \DateTime($firstSegment->departureDate ?? '') : null;
          $arrivalDateTime = $lastSegment ? new \DateTime($lastSegment->arrivalDate ?? '') : null;

          $totalDuration = ($departureDateTime && $arrivalDateTime)
          ? $departureDateTime->diff($arrivalDateTime)
          : null;
          @endphp

          @if ($firstSegment && $lastSegment)
          <table style="width: 100%; font-family: Arial, sans-serif; border-collapse: collapse; margin-bottom: 20px;">
            <!-- Header -->
            <tr>
              @if($bookingDetail?->additional_details == 'multi-city')
              <td colspan="1" style="background-color: #005C8B; color: white; padding: 10px; font-weight: bold; border-radius:10px">
                {{ 'Departure Flight' }}
                ({{ $numberOfStops > 0 ? $numberOfStops . ' Stop' . ($numberOfStops > 1 ? 's' : '') : 'Non-Stop' }})
              </td>
              @else
              <td colspan="1" style="background-color: #005C8B; color: white; padding: 10px; font-weight: bold; border-radius:10px">
                {{ $i % 2 == 0 ? 'Departure Flight' : 'Return Flight' }}
                ({{ $numberOfStops > 0 ? $numberOfStops . ' Stop' . ($numberOfStops > 1 ? 's' : '') : 'Non-Stop' }})
              </td>
              @endif
            </tr>

            <!-- Each Segment -->
            @foreach ($segments as $sIndex => $segment)
            @php
            $departureDateTime = isset($segment->departureDate) ? new \DateTime($segment->departureDate) : null;
            $arrivalDateTime = isset($segment->arrivalDate) ? new \DateTime($segment->arrivalDate) : null;

            $carrierCode = $segment->carrierCode ?? '';
            $operatedByCode = $segment->operating->carrierCode ?? '';
            $airlineMap = collect($airlineList)->keyBy('code');
            $operatedByAirline = $operatedByCode ? ($airlineMap[$operatedByCode] ?? null) : null;

            @endphp
            <tr>
              <td style="width: 18%; padding: 10px; vertical-align: top; text-align: center;">
                <div style="position: relative; display: inline-block; background: #F0F7FE; padding: 15px; text-align: center; border-radius: 15px;">

                  <!-- Operated By Logo (behind, slightly offset) -->
                  @if ($carrierCode != $operatedByCode && !empty($operatedByAirline->logo))
                  <img src="{{ $operatedByAirline->logo }}"
                    alt="{{ $operatedByAirline->name }}"
                    style="width: 65px; height: 65px; border-radius: 50%; object-fit: contain;
                           position: absolute; top: 25px; left: 50px;
                           border: 2px solid #fff; background: white;
                           opacity: 0.85; z-index: 1;">
                  @endif

                  <!-- Main Airline Logo -->
                  <img src="{{ $segment->airlineData->logo ?? '' }}"
                    alt="{{ $segment->airlineData->name ?? '' }}"
                    style="width: 70px; height: 70px; border-radius: 50%; object-fit: contain;
                           display: block; margin: 0 auto; background: #fff; position: relative; z-index: 2;">
                </div>


                <div style="margin-top: 8px; font-size: 0.9em; line-height: 1.3; color: #333; text-align: center;">
                  <strong style="font-size: 1em;">{{ $segment->airlineData->name ?? '' }}</strong><br>
                  {{ $segment->aircraftData->name ?? '' }}
                </div>
                <!-- Operated By Logo -->
                @if ($carrierCode != $operatedByCode && !empty($operatedByAirline->logo))
                <div style="margin-top: 8px; font-size: 0.9em; line-height: 1.3; color: #333; text-align: center; background-color: lightgray; padding: 5px; border-radius: 5px;">
                  <strong style="font-size: 1em;"> {{ $operatedByAirline->name ? ' Operated By '. $operatedByAirline->name : ''  }}</strong>
                </div>
                @endif

              </td>

              <td style="width: 25%; text-align: left; padding: 10px;">
                <div style="font-size: 1.5em; font-weight: bold;">
                  {{ $departureDateTime ? $departureDateTime->format('H:i') : '' }}
                </div>
                @php
                $hour = isset($departureDateTime) ? (int) $departureDateTime->format('H') : null;
                $iconHtml = '<i class="fas fa-question-circle" style="color: gray;"></i>'; // fallback icon

                if (!is_null($hour)) {
                if ($hour >= 5 && $hour < 12) {
                  $iconHtml='<i class="fas fa-sun" style="color: orange;"></i>' ; // Morning
                  } elseif ($hour>= 12 && $hour < 17) {
                    $iconHtml='<i class="fas fa-sun" style="color: #f0ad4e;"></i>' ; // Afternoon
                    } elseif ($hour>= 17 && $hour < 21) {
                      $iconHtml='<i class="fas fa-cloud-sun" style="color: orange;"></i>' ; // Evening
                      } else {
                      $iconHtml='<i class="fas fa-moon" style="color: #003366;"></i>' ; // Night
                      }
                      }
                      @endphp
                      <div style="font-size: 0.9em;">
                      {!! $iconHtml !!}
                      {{ $segment->departureAirportData->iataCode ?? '' }}<br>
                      {{ $segment->departureAirportData->city_name ?? (getCityNameByAirportCode($segment->departureAirportData->code) ?? '') }},
                      {{ $segment->departureAirportData->country_name ?? (getCountryNameByAirportCode($segment->departureAirportData->code) ?? '') }}<br>
                      {{ $departureDateTime ? $departureDateTime->format('D d M') : '' }}<br>
                      Terminal {{ $segment->departure->terminal ?? '-' }}
      </div>
      </td>

      <td style="width: 10%; text-align: center; vertical-align: middle; padding: 10px;">
        {!! $flightIcon !!}
        <div style="font-size: 0.9em; margin-top: 5px;">
          {{ $segment->durationText ?? '-' }}
        </div>
      </td>

      <td style="width: 25%; text-align: left; padding: 10px;">
        <div style="font-size: 1.5em; font-weight: bold;">
          {{ $arrivalDateTime ? $arrivalDateTime->format('H:i') : '' }}
        </div>
        @php
        $hour = isset($arrivalDateTime) ? (int) $arrivalDateTime->format('H') : null;
        $iconHtml = '<i class="fas fa-question-circle" style="color: gray;"></i>'; // fallback icon

        if (!is_null($hour)) {
        if ($hour >= 5 && $hour < 12) {
          $iconHtml='<i class="fas fa-sun" style="color: orange;"></i>' ; // Morning
          } elseif ($hour>= 12 && $hour < 17) {
            $iconHtml='<i class="fas fa-sun" style="color: #f0ad4e;"></i>' ; // Afternoon
            } elseif ($hour>= 17 && $hour < 21) {
              $iconHtml='<i class="fas fa-cloud-sun" style="color: orange;"></i>' ; // Evening
              } else {
              $iconHtml='<i class="fas fa-moon" style="color: #003366;"></i>' ; // Night
              }
              }
              @endphp
              <div style="font-size: 0.9em;">
              {!! $iconHtml !!}
              {{ $segment->arrivalAirportData->iataCode ?? '' }}<br>
              {{ $segment->arrivalAirportData->city_name ?? (getCityNameByAirportCode($segment->arrivalAirportData->code) ?? '') }},
              {{ $segment->arrivalAirportData->country_name ?? (getCountryNameByAirportCode($segment->arrivalAirportData->code) ?? '') }}<br>
              {{ $arrivalDateTime ? $arrivalDateTime->format('D d M') : '' }}<br>
              Terminal {{ $segment->arrival->terminal ?? '-' }}
    </div>
    </td>
    </tr>

    {{-- Show layover info between segments --}}
    @if ($sIndex < count($segments) - 1)
      @php
      $nextSegment=$segments[$sIndex + 1];
      $layoverArrival=$arrivalDateTime;
      $nextDeparture=isset($nextSegment->departureDate) ? new \DateTime($nextSegment->departureDate) : null;
      $layoverDuration = ($layoverArrival && $nextDeparture) ? $layoverArrival->diff($nextDeparture) : null;
      @endphp

      <tr>
        <td colspan="4" style="text-align: center; font-size: 0.9em; color: #555; padding: 8px;">
          Layover at {{ $segment->arrivalAirportData->city_name ?? (getCityNameByAirportCode($segment->arrivalAirportData->code) ?? '') }},
          {{ $segment->arrivalAirportData->country_name ??  (getCountryNameByAirportCode($segment->arrivalAirportData->code) ?? '') }}
          @if ($layoverDuration)
          - {{ $layoverDuration->format('%h hrs %i mins') }}
          @endif
        </td>
      </tr>
      @endif
      @endforeach
      </table>

      @php $i++; @endphp
      @endif
      @endforeach
      @endforeach



      @endif



      <table>
        <tr>
          <td>
            <h3 style="color: #005C8B; font-size: 1.5em; font-weight:bold">Traveller Details</h3>
          </td>
          <td>

          </td>

        </tr>

      </table>

      <hr style="border: 1px solid black; margin: 20px 0;">



      @if (!empty($passengerDetails))
      @php
      $brandedLookup = [];

      if (!empty($brandedFares)) {
      foreach ($brandedFares as $segmentGroup) {
      foreach ($segmentGroup as $branded) {
      if (isset($branded->segmentId)) {
      $brandedLookup[$branded->segmentId] = $branded;
      }
      }
      }
      }
      @endphp

      @foreach ($passengerDetails as $pkey => $pvalue)
      <div style="font-family: Arial, sans-serif; margin: 20px;">
        <!-- Passenger Header -->
        <div style="background-color: #005C8B; color: white; padding: 10px; font-weight: bold; border-radius:5px 5px;">
          {{ ucfirst($pvalue->title ?? '') }}
          {{ ucfirst($pvalue->first_name ?? '') }}
          {{ $pvalue->second_name ?? '' }}
          {{ ucfirst($pvalue->last_name ?? '') }}
          @isset($pvalue->traveler_type)
          ({{ ucfirst($pvalue->traveler_type ?? '') }})
          @endisset
        </div>

        @foreach ($editedflightInfo as $index => $directionInfo)
        @php
        $flights = is_array($directionInfo->flights) ? $directionInfo->flights : [$directionInfo->flights];
        $directionInfo->flights;

        $segments = $flight->segments ?? [];
        $branded = $brandedFares[$index] ?? null;

        $seat = [];
        if (is_object($seatDetails) && property_exists($seatDetails, 'status') && $seatDetails->status) {
        // Case 1: object with nested seatDetails
        $seatArray = $seatDetails->seatDetails->seatDetails ?? [];

        $seat = $seatArray[$index] ?? [];
        }

        elseif (is_array($seatDetails)) {
        // Case 2 or 3: array of arrays or array of objects
        if (isset($seatDetails[$index])) {
        // Check if it's a nested array (case 2)
        if (is_array($seatDetails[$index]) && isset($seatDetails[$index][0])) {
        $seat = $seatDetails[$index][0];
        } else {
        // Flat array of objects (case 3)
        $seat = $seatDetails[$index];
        }
        }
        }


        if($bagDetails){

        if( isset($bagDetails) ){
        $bag = $bagDetails[0] ?? [];
        }
        else{
        $bag = [];
        }
        }
        else{
        $bag = [];
        }


        $stopCount = count($segments) - 1;
        @endphp

        @foreach ($flights as $fIndex => $flight)
        @php
        $segments = $flight->segments ?? [];
        $stopCount = count($segments) - 1;
        @endphp
        @if ($flight)

        <!-- Trip Header -->
        <div style="margin-top: 20px; font-size: 1em; font-weight: bold; color: #005C8B;">
          Trip {{ $loop->iteration }}:
          {{ $flight->departureAirport ?? ' ' }} - {{ $flight->arrivalAirport ?? ' ' }}
          @if ($stopCount > 0)
          <small style="color: #555;">({{ $stopCount }} Stop{{ $stopCount > 1 ? 's' : '' }})</small>
          @else
          <small style="color: #555;">(Non-stop)</small>
          @endif
        </div>

        <!-- Segment Table -->
        <table style="width: 100%; border-collapse: collapse; text-align: left; margin-top: 10px; font-size: 0.9em;table-layout: fixed;">
          <thead>
            <tr>
              <th style="border: 1px solid #ddd; padding: 8px; background-color:#EDF1FE ; width:10%">Segment</th>
              <th style="border: 1px solid #ddd; padding: 8px; background-color:#EDF1FE; width:10%">E-Ticket No.</th>
              <th style="border: 1px solid #ddd; padding: 8px; background-color:#EDF1FE; width:10%">Airline PNR</th>
              <th style="border: 1px solid #ddd; padding: 8px; background-color:#EDF1FE; width:10%">Seat No.</th>
              <th style="border: 1px solid #ddd; padding: 8px; background-color:#EDF1FE; width:20%">Baggage Allowance</th>
              <th style="border: 1px solid #ddd; padding: 8px; background-color:#EDF1FE; width:20%">Cabin Baggage</th>
              <th style="border: 1px solid #ddd; padding: 8px; background-color:#EDF1FE; width:20%">Extra Baggage</th>
            </tr>
          </thead>
          <tbody>

            @foreach ($segments as $skey => $seg)

            @php

            // PNR
            $pnr = '-';
            if (!empty($airlinePnr) && is_array($airlinePnr)) {
            if (count($airlinePnr) <= 1) {
              $pnr=$airlinePnr[0] ?? '-' ;
              } else {
              $pnr=$airlinePnr[$index] ?? '-' ;
              }


              $pnr=trim(str_replace(['PNR', 'pnr' ], '' , $pnr));
              }

              // Seat

              //$seatNumber=$seat->ticket_details->seat_number ?? ' ';
              $seatNumber = '-';
              $travelerId = (string) ($pkey + 1); // Match seatDetails travelerId to passenger index + 1

              foreach ($seatDetails as $seatItem) {
              if (
              isset($seatItem->segmentId)
              && isset($seatItem->travelerId)
              && $seatItem->segmentId == $seg->id
              && $seatItem->travelerId == $travelerId
              && isset($seatItem->ticket_details->seat_number)
              ) {
              $seatNumber = $seatItem->ticket_details->seat_number;
              break;
              }
              }



              // Extra Baggage
              $extraBaggage = 'No Extra Baggage';
              $icon = '<i class="fa fa-times" style="color: white; background-color: red; border-radius: 50%; padding: 3px;"></i>';

              if (!empty($bag) && !empty($bag->selectedBagDetails)) {
              foreach ($bag->selectedBagDetails as $bagDetail) {
              if (
              isset($bagDetail->segmentId, $bagDetail->travelerId, $bagDetail->bag->quantity)
              && $bagDetail->segmentId == $seg->id
              && $bagDetail->travelerId == $pkey
              ) {
              $quantity = $bagDetail->bag->quantity;
              if ($quantity > 0) {
              $icon = '<i class="fa fa-plus" style="color: white; background-color: blue; border-radius: 50%; padding: 2px;"></i>';
              $extraBaggage = $quantity . ' Piece' . ($quantity > 1 ? 's' : '');
              }
              break;
              }
              }
              }

              // Baggage
              $branded = $brandedLookup[$seg->id] ?? null;
              $checkedBaggage = $branded->checkedBaggage[0] ?? null;
              $cabinBaggage = $branded->cabinBaggage ?? null;

              $checkedbaggageDesc = $checkedBaggage->description_en ?? ' ';
              $checkedBaggageIcon = !empty($checkedBaggage->status)
              ? '<i class="fa fa-check" style="color: white; background-color: green; border-radius: 50%; padding: 2px;"></i>'
              : '<i class="fa fa-times" style="color: white; background-color: red; border-radius: 50%; padding: 4px;"></i>';

              if (!$checkedBaggage) {
              $checkedbaggageDesc = ' ';
              $checkedBaggageIcon = '<i class="fa fa-times" style="color: white; background-color: red; border-radius: 50%; padding: 4px;"></i>';
              }

              $cabinbaggageDesc = $cabinBaggage->description_en ?? ' ';
              $cabinbaggageIcon = !empty($cabinBaggage->status)
              ? '<i class="fa fa-check" style="color: white; background-color: green; border-radius: 50%; padding: 2px;"></i>'
              : '<i class="fa fa-times" style="color: white; background-color: red; border-radius: 50%; padding: 4px;"></i>';

              if (!$cabinBaggage) {
              $cabinbaggageDesc = ' ';
              $cabinbaggageIcon = '<i class="fa fa-times" style="color: white; background-color: red; border-radius: 50%; padding: 4px;"></i>';
              }
              @endphp

              <tr>
                <td style="border: 1px solid #ddd; padding: 8px; white-space: normal; overflow-wrap: break-word;">
                  {{ $seg->departure->iataCode ?? ' ' }} - {{ $seg->arrival->iataCode ?? ' ' }}
                </td>
                <td style="border: 1px solid #ddd; padding: 8px; white-space: normal; overflow-wrap: break-word; word-break: break-all;">
                  {{ $bookingDetail->ticket_numbers ?? '-' }}
                </td>
                <td style="border: 1px solid #ddd; padding: 8px; white-space: normal; overflow-wrap: break-word; word-break: break-all;">
                  {{ $seg->airlinePNR ?? (!empty($gdsPnr) ? implode(',', $gdsPnr) : '') }}
                </td>
                <td style="border: 1px solid #ddd; padding: 8px; white-space: normal; overflow-wrap: break-word; word-break: break-all;; word-break: break-all;">
                  {{ $seatNumber }}
                </td>
                <td style="border: 1px solid #ddd; padding: 8px; white-space: normal; overflow-wrap: break-word;">
                  {!! $checkedBaggageIcon !!} {{ $checkedbaggageDesc ?? '' }}
                </td>
                <td style="border: 1px solid #ddd; padding: 8px; white-space: normal; overflow-wrap: break-word;">
                  {!! $cabinbaggageIcon ?? '' !!} {{ $cabinbaggageDesc ?? '' }}
                </td>
                <td style="border: 1px solid #ddd; padding: 8px; white-space: normal; overflow-wrap: break-word;">
                  {!! $icon !!} {{ $extraBaggage ?? 'Nil' }}
                </td>
              </tr>

              @endforeach
          </tbody>
        </table>

        <!-- Special Request -->
        <div style="margin-top: 10px; font-size: 0.85em; color: #555;">
          <strong>Special Request:</strong>
          {{ $segments[0]->segmentFare->specialRequest ?? 'No Special Request' }}
        </div>
        @endif
        @endforeach
        @endforeach
      </div>
      @endforeach
      @endif


      <!-- Notification Section -->
      <div style="background-color: #e9f5fb; padding: 10px; border: 1px solid #cfe4ee; border-radius: 5px; display: flex; align-items: center; margin-bottom: 20px;">
        <div style="color: #007bff; font-size: 20px; margin-right: 10px;">&#9432;</div>
        <p style="margin: 0; color: #007bff; font-size: 14px;">
          All Fees are applicable up to 48H before the Outbound Flight departure Time. Additional Fees may apply after that.
        </p>
      </div>

      <!-- Useful Info Section -->
      <table style="width: 100%; background-color: #ffffff; border: 1px solid #ddd; border-radius: 5px; padding: 20px;">
        <tr>
          <td colspan="2" style="padding-bottom: 15px;">
            <h3 style="color: #09496d; font-size: 18px; margin: 0;">Useful info:</h3>
          </td>
        </tr>
        <tr>
          <td colspan="2" style="padding: 15px 25px;">
            @if($pageDetails)
            <p style="font-size: 20px; color: #333; line-height: 3.6; margin: 0;">
              {!! $pageDetails->page_content !!}
            </p>

            @endif
          </td>
        </tr>

      </table>

      <table style="margin-top:10px">
        <tr>
          <td style="text-align: start;">
            <p style="font-size:1em;"><i class="fas fa-phone" style=" color: #09496d;"> </i> Contact us: {{ $invoiceSettings ? ($invoiceSettings?->phone_code . " " . $invoiceSettings?->phone_no) : "+966 920001818"  }}</p>
          </td>
          <td style="text-align: center;">
            <p style="font-size:1em;"><i class="fab fa-whatsapp" style="color: #09496d;"></i> Whatsapp us: {{ $invoiceSettings ? ($invoiceSettings?->phone_code . " " . $invoiceSettings?->phone_no) : "+966 920001818"  }}</p>
          </td>
          <td style="text-align: end;">
            <a href="https://www.linkedin.com" target="_blank">
              <i class="fab fa-linkedin" style=" color: #09496d;"></i>
            </a>&nbsp;

            <!-- Facebook Icon -->
            <a href="https://www.facebook.com" target="_blank">
              <i class="fab fa-facebook-f" style=" color: #09496d;"></i>
            </a>&nbsp;

            <!-- X (formerly Twitter) Icon -->
            <a href="https://www.x.com" target="_blank">
              <i class="fab fa-x" style=" color: #09496d;"></i>
            </a>&nbsp;

            <!-- YouTube Icon -->
            <a href="https://www.youtube.com" target="_blank">
              <i class="fab fa-youtube" style=" color: #09496d;"></i>
            </a>
          </td>
        </tr>
      </table>



      <div class="col-md-12">



        <table class="table mt-5 invoice_table" style="width: 100%;">




        </table>


        <!-- End of Table Invoice Content -->





      </div>



      <table>
        <tr>
          <td></td>
          <td></td>
          <td></td>
          <td>
            <div class="qr-footer">
              <!-- <img src="{{ URL::asset('assets/images/qr.png') }}" alt="Logo"> -->
            </div>
          </td>
        </tr>
      </table>

  </div><!--End InvoiceTop-->




  </div><!--End Invoice-->
  </div><!-- End Invoice Holder-->





</body>

</html>