@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<style>
.form-item input.is-valids+label {
    font-size: 11px;
    top: -5px;
}

.hidden {
    display: none;
}
</style>
      <div class="content-header">
        <div class="container-fluid">
          <div class="row mb-4 mt-2">
            <div class="col-sm-12 align-items-center d-flex breadcrumb-style">
              <h1 class="m-0">View API Details</h1>
              <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">@lang('adminUser.dashboard') </a></li>
                <li class="breadcrumb-item"><a href="{{ route('api-list.index') }}">API List</a></li>

                <li class="breadcrumb-item active">@lang('adminUser.view')</li>
              </ol>
              <div class="breadcrumb-btn">

                <div class="add-breadcrumb">
                  <a class="" href="{{ route('api-list.edit',$apiDetails['id']) }}">
                    <?xml version="1.0"?>
                    <svg fill="#fff" viewBox="0 0 24 24" width="20" height="20">
                    <path
                        d="M 19.171875 2 C 18.448125 2 17.724375 2.275625 17.171875 2.828125 L 16 4 L 20 8 L 21.171875 6.828125 C 22.275875 5.724125 22.275875 3.933125 21.171875 2.828125 C 20.619375 2.275625 19.895625 2 19.171875 2 z M 14.5 5.5 L 3 17 L 3 21 L 7 21 L 18.5 9.5 L 14.5 5.5 z" />
                    </svg>
                  Edit
                  </a>
                </div>
              </div>
            </div><!-- /.col -->

          </div><!-- /.row -->
        </div><!-- /.container-fluid -->
      </div>
      <!-- /.content-header -->

      <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Info boxes -->
            <div class="row">
                <div class="card pb-4 pt-4 px-3 w-100">
                    <div class="row view_page mb-0">
                        <div class="col-md-12 mt-3">
                            <div class="view_user_data">


                                <div class="form-item form-float-style form-group">
                                    <input type="text" value="<?php echo $apiDetails['api_category']; ?>" id="api_category" name="api_category" autocomplete="off" class="is-valid" readonly>
                                    <label for="api_category">API Category <span class="req-star">*</span></label>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <input type="text" value="<?php echo $apiDetails['api_method']; ?>" id="api_method" name="api_method" autocomplete="off" class="is-valid" readonly>
                                    <label for="api_method">API Method <span class="req-star">*</span></label>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <input type="text" value="<?php echo $apiDetails['api_title']; ?>" id="api_title" name="api_title" autocomplete="off" class="is-valid" readonly>
                                    <label for="api_title">API Title <span class="req-star">*</span></label>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <input type="text" value="<?php echo $apiDetails['api_url']; ?>" id="api_url" name="api_url" autocomplete="off" class="is-valid">
                                    <label for="api_title">API URL <span class="req-star">*</span></label>
                                </div>
                                <div class="form-floating form-float-style form-group required mb-3">
                                    <div class="form-item form-float-style serach-rem mb-3">
                                        <div class="select top-space-rem after-drp form-float-style form-group">
                                            <select name="is_header_auth" id="is_header_auth" class="select-text height_drp">
                                            <option value="yes"<?php echo $apiDetails['is_header_auth'] == 'yes' ? ' selected': ''; ?>>Yes</option>
                                            <option value="no"<?php echo $apiDetails['is_header_auth'] == 'no' ? ' selected': ''; ?>>No</option>
                                            </select>
                                            <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Auth Header need? <span class="req-star">*</span></label>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <textarea name="request_payload" id="request_payload" rows="12" cols="50" style="height:350px;" readonly><?php echo $apiDetails['request_payload']?></textarea>
                                    <label for="request_payload">Request Payload<span class="req-star">*</span></label>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <textarea name="success_response" id="success_response" rows="12" cols="50" style="height:350px;" readonly><?php echo $apiDetails['success_response']?></textarea>
                                    <label for="success_response">Success Response<span class="req-star">*</span></label>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <textarea name="error_response" id="error_response" rows="8" cols="50" style="height:220px;" readonly><?php echo $apiDetails['error_response']?></textarea>
                                    <label for="error_response">Error Response<span class="req-star">*</span></label>
                                </div>
                                <div class="form-item form-float-style form-group">
                                    <textarea name="description" id="description" rows="8" cols="50" style="height:220px;" readonly><?php echo $apiDetails['description']?></textarea>
                                    <label for="description">Description</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </div>
        <!--/. container-fluid -->
    </section>

      @endsection
