@extends('admin.layout.main')
@section('title',$header['title'])

@section('content')
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/css/bootstrap-select.min.css">

<style>
  .form-item input.is-valids+label {
    font-size: 11px;
    top: -5px;
  }

  .hidden {
    display: none;
  }
</style>


<!-- /.Start content-header -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-4 mt-2">
      <div class="col-sm-12 d-flex breadcrumb-style">
        <h1 class="m-0">Add API Details</h1>
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">Dashboard </a></li>
          <li class="breadcrumb-item"><a href="{{ route('api-list.index') }}">API List</a></li>
          <li class="breadcrumb-item active">Add</li>
        </ol>
      </div><!-- /.col -->

    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.End content-header -->



<!-- Main content -->
<section class="content">
  <!-- Start container fluid -->
  <div class="container-fluid">
    <!-- Start Row Div -->
    <div class="row">
      <form id="basicForm" class="form validate mb-3 ml-0 mr-0 mt-0" action="{{ route('api-list.store') }}" method="post" enctype="multipart/form-data">
        <div class="card pb-4 pt-4 px-3 w-100">

          <div class="col-md-12">
            <div class="form-group">
              @if (session('success'))
              <div class="alert alert-success" role="alert">
                <?php echo session('success'); ?>
              </div>
              @endif
              @if (session('error'))
              <div class="alert alert-danger" role="alert">
                {{ session('error') }}
              </div>
              @endif
              @if (isset($error))
              <div class="alert alert-danger" role="alert">
                {{ $error }}
              </div>
              @endif
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-12 discount">
              @csrf
              <h5 class="setting-title">API Details</h5>
              <div class="form-floating form-float-style form-group required mb-3">
                <div class="form-item form-float-style serach-rem mb-3">
                    <div class="select top-space-rem after-drp form-float-style form-group">
                        <select name="api_category" id="api_category" class="is-valid selectpicker select-text height_drp is-valid select-validate">
                            <option value="B2C">B2C</option>
                            <option value="Core">Core</option>
                            <option value="Customer">Customer</option>
                            <option value="Flights">Flights</option>
                            <option value="Geography">Geography</option>
                            <option value="Hotels">Hotels</option>
                            <option value="Login/Signup">Login/Signup</option>
                            <option value="Profile">Profile</option>
                            <option value="Flight Bookings">Flight Bookings</option>
                        </select>
                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">API Title <span class="req-star">*</span></label>
                    </div>
                </div>
              </div>
              <div class="form-floating form-float-style form-group required mb-3">
                <div class="form-item form-float-style serach-rem mb-3">
                    <div class="select top-space-rem after-drp form-float-style form-group">
                        <select name="api_method" id="api_method" class="is-valid selectpicker select-text height_drp is-valid select-validate">
                            <option value="GET">GET</option>
                            <option value="POST">POST</option>
                            <option value="PUT">PUT</option>
                            <option value="DELETE">DELETE</option>
                        </select>
                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">API Method <span class="req-star">*</span></label>
                    </div>
                </div>
              </div>
              <div class="form-item form-float-style form-group">
                <input type="text" value="" id="api_title" name="api_title" autocomplete="off" class="is-valid">
                <label for="api_title">API Title <span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <input type="text" value="" id="api_url" name="api_url" autocomplete="off" class="is-valid">
                <label for="api_title">API URL <span class="req-star">*</span></label>
              </div>
              <div class="form-floating form-float-style form-group required mb-3">
                <div class="form-item form-float-style serach-rem mb-3">
                    <div class="select top-space-rem after-drp form-float-style form-group">
                        <select name="is_header_auth" id="is_header_auth" class="is-valid selectpicker select-text height_drp is-valid select-validate">
                            <option value="yes">Yes</option>
                            <option value="no">No</option>
                        </select>
                        <label class="select-label searchable-drp" style="font-size: 12px; font-weight: 400 !important;">Auth Header need? <span class="req-star">*</span></label>
                    </div>
                </div>
              </div>
              <div class="form-item form-float-style form-group">
                <textarea name="request_payload" id="request_payload" rows="12" cols="50" style="height:350px;"></textarea>
                <label for="request_payload">Request Payload<span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <textarea name="success_response" id="success_response" rows="12" cols="50" style="height:350px;"></textarea>
                <label for="success_response">Success Response<span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <textarea name="error_response" id="error_response" rows="8" cols="50"></textarea>
                <label for="error_response">Error Response<span class="req-star">*</span></label>
              </div>
              <div class="form-item form-float-style form-group">
                <textarea name="description" id="description" rows="8" cols="50"></textarea>
                <label for="description">Description</label>
              </div>
            </div><!-- End general information div-->
            <div class="col-md-6 discount">
              <div class="cards-btn">
                <button type="submit" id="disBtn" class="btn btn-success form-btn-success">Submit</button>
                <a href="{{ route('api-list.index') }}" class="btn btn-danger form-btn-danger">Cancel</a>
              </div>

            </div>
      </form>

    </div>
  </div>
  </div>
  </div>
  </div>
  </div>



  </div>
  <!-- /.row -->
  </div>
  <!-- End Row Div -->

  </div>

  <!-- End container fluid -->
</section>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/bootstrap-select@1.14.0-beta3/dist/js/bootstrap-select.min.js"></script>

@append
