<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('wallets', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('customer_id', 200);
            $table->string('booking_id');
            $table->integer('balance')->default(0);
            $table->double('wallet_used_amount');
            $table->string('currency', 50);
            $table->string('attachment')->nullable();
            $table->enum('type', ['credit', 'debit'])->nullable();
            $table->string('wallet_used_status', 50)->nullable();
            $table->double('used_temp_amount');
            $table->string('temp_amount_currency', 10);
            $table->double('converted_used_amount');
            $table->date('expiry_date')->nullable();
            $table->string('used_date')->nullable();
            $table->enum('status', ['active', 'inactive'])->default('active');
            $table->timestamp('created_at')->useCurrentOnUpdate()->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->string('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('wallets');
    }
};
