<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('users', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->integer('agency_id')->default(0);
            $table->string('google_id');
            $table->string('facebook_id');
            $table->tinyInteger('primary_user')->default(0);
            $table->string('name');
            $table->string('profile_image')->nullable();
            $table->string('email');
            $table->string('isd')->nullable()->default('+91');
            $table->string('mobile');
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password')->nullable();
            $table->dateTime('password_updated_at')->nullable();
            $table->rememberToken();
            $table->tinyInteger('status')->default(1)->comment('0 for In-active, 1 for Active');
            $table->string('role_code')->default('SUPER_ADMIN');
            $table->set('app_name', ['managerapp', 'b2bapp', 'supplierapp'])->default('managerapp');
            $table->timestamps();
            $table->string('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('users');
    }
};
