<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('state_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('state_id', 36)->index('state_i18ns_state_id_foreign');
            $table->string('state_name');
            $table->string('language_code')->index('state_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('state_i18ns');
    }
};
