<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sms_template_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('sms_id', 36)->index('sms_template_i18ns_sms_id_foreign');
            $table->string('name');
            $table->text('content');
            $table->string('language_code')->index('sms_template_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sms_template_i18ns');
    }
};
