<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('seo_trending_hotels', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('city_en');
            $table->string('city_ar');
            $table->tinyInteger('status');
            $table->longText('content')->nullable();
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->nullable();
            $table->string('arabic_content')->nullable();
            $table->string('title')->nullable();
            $table->string('arabic_title')->nullable();
            $table->string('sub_title')->nullable();
            $table->string('arabic_sub_title')->nullable();
            $table->string('banner_title')->nullable();
            $table->string('arabic_banner_title')->nullable();
            $table->string('banner')->nullable();
            $table->string('banner_sub_title')->nullable();
            $table->string('arabic_banner_sub_title')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('seo_trending_hotels');
    }
};
