<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('sales_service_markups', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('service_name');
            $table->string('service_type');
            $table->string('cabin_class')->nullable();
            $table->integer('markup_percentage')->default(0);
            $table->integer('fixed_service_fee')->default(0);
            $table->string('sales_service_type');
            $table->string('status')->default('active');
            $table->string('created_by')->nullable();
            $table->timestamps();
            $table->text('deleted_at')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('sales_service_markups');
    }
};
