<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('roles', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('name')->unique()->comment('role name');
            $table->string('code')->unique()->comment('role code that identity of role, this is the copy of name with uppercase and replace space by underscore(_). Role code is not changable');
            $table->text('description')->comment('role description');
            $table->set('role_type', ['manager', 'supplier', 'b2b'])->default('manager');
            $table->tinyInteger('status')->default(1)->comment('0 for In-active, 1 for Active');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('roles');
    }
};
