<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('popular_travels', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('name');
            $table->string('url');
            $table->string('price');
            $table->string('thumbnail');
            $table->string('country_code')->nullable();
            $table->string('city_code')->nullable();
            $table->tinyInteger('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('popular_travels');
    }
};
