<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('payments', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('merchant_transaction_id')->nullable();
            $table->string('payment_id');
            $table->char('booking_id', 36)->index('booking_id');
            $table->string('currency')->nullable();
            $table->decimal('amount', 10);
            $table->decimal('booking_cancel_amount', 10)->nullable();
            $table->decimal('refund_amount', 10)->nullable();
            $table->string('payment_type');
            $table->string('payment_brand');
            $table->string('payment_flow');
            $table->string('payment_status')->nullable();
            $table->string('debit')->nullable();
            $table->string('debit_id')->nullable();
            $table->string('debit_code')->nullable();
            $table->string('debit_description')->nullable();
            $table->text('debit_response')->nullable();
            $table->string('pre_authorization')->nullable();
            $table->string('pre_authorization_id')->nullable();
            $table->string('pre_authorization_code')->nullable();
            $table->string('pre_authorization_description')->nullable();
            $table->text('pre_authorization_response')->nullable();
            $table->string('capture')->nullable();
            $table->string('capture_id')->nullable();
            $table->string('capture_code')->nullable();
            $table->string('capture_description')->nullable();
            $table->text('capture_response')->nullable();
            $table->string('revert')->nullable();
            $table->string('revert_id')->nullable();
            $table->string('revert_code')->nullable();
            $table->string('revert_description')->nullable();
            $table->text('revert_response')->nullable();
            $table->string('refund_status')->nullable();
            $table->longText('refund_response')->nullable();
            $table->timestamp('refund_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('payments');
    }
};
