<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('notification_changes', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->bigInteger('notification_object_id');
            $table->bigInteger('actor_id');
            $table->tinyInteger('is_app_user')->default(0);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('notification_changes');
    }
};
