<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('markups_channel', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('markups_id', 36)->nullable()->index('markups_channel_markups_id_foreign')->comment('reference id key of markups table');
            $table->enum('channel', ['b2b', 'b2c_desktop', 'b2c_mobile_app', 'b2c_mobile_browser'])->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('markups_channel');
    }
};
