<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('markups_airline', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('markups_id', 36)->nullable()->index('markups_airline_markups_id_foreign')->comment('reference id key of markups table');
            $table->char('airline_id', 36)->nullable()->index('markups_airline_airline_id_foreign')->comment('reference id key of airline table');
            $table->string('airline_code')->nullable()->index('markups_airline_airline_code_foreign')->comment('reference airline code key of airline table');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('markups_airline');
    }
};
