<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('markups_agent', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('markups_id', 36)->nullable()->index('markups_agent_markups_id_foreign')->comment('reference id key of markups table');
            $table->unsignedBigInteger('agency_id')->nullable()->index('markups_agent_agency_id_foreign')->comment('reference id key of agencies table');
            $table->char('agent_group_id', 36)->nullable()->comment('reference id key of agent group table');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('markups_agent');
    }
};
