<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loyalty_points_map', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('service')->index('service');
            $table->string('calculation_type');
            $table->integer('value');
            $table->string('city')->nullable();
            $table->string('service_provider')->nullable();
            $table->string('from_place')->nullable();
            $table->string('to_place')->nullable();
            $table->date('start_date')->nullable();
            $table->date('end_date')->nullable();
            $table->integer('is_common')->nullable();
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->timestamp('updated_at')->default('0000-00-00 00:00:00');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loyalty_points_map');
    }
};
