<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('loyalty_point_settings', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('expiry_year')->nullable();
            $table->string('expiry_month')->nullable();
            $table->string('expiry_day')->nullable();
            $table->double('point_to_amount')->default(200);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('loyalty_point_settings');
    }
};
