<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_special_requests', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('special_request_name');
            $table->string('special_request_name_ar')->nullable();
            $table->tinyInteger('status')->default(0);
            $table->string('created_by');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_special_requests');
    }
};
