<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('hotel_descriptions', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('hotelid')->index('idx_hotelid');
            $table->string('title');
            $table->string('language', 10)->default('en');
            $table->integer('line');
            $table->text('paragraph');
            $table->timestamp('created_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('hotel_descriptions');
    }
};
