<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('home_banners', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->enum('banner_type', ['mobile', 'web'])->default('web');
            $table->string('media_type')->default('image');
            $table->string('banner_image')->nullable();
            $table->string('video_link')->nullable();
            $table->integer('category_id')->nullable();
            $table->date('from_date');
            $table->date('to_date');
            $table->integer('sort_order')->nullable();
            $table->enum('panel', ['b2c', 'b2b', 'supplier'])->default('b2c');
            $table->tinyInteger('status')->default(1)->comment('0 for In-active, 1 for Active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('home_banners');
    }
};
