<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('home_banner_i18ns', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->char('banner_id', 36)->index('home_banner_i18ns_banner_id_foreign');
            $table->string('banner_title');
            $table->string('language_code')->index('home_banner_i18ns_language_code_foreign');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('home_banner_i18ns');
    }
};
