<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('favourites', function (Blueprint $table) {
            $table->integer('id', true);
            $table->string('hotel_id', 250);
            $table->string('customer_id', 250);
            $table->string('image');
            $table->string('title', 200);
            $table->string('address', 200);
            $table->integer('price');
            $table->integer('rating');
            $table->integer('status');
            $table->string('type', 200);
            $table->text('url_params');
            $table->string('language_code', 20)->default('en');
            $table->timestamp('created_at')->useCurrentOnUpdate()->useCurrent();
            $table->dateTime('updated_at')->useCurrent();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('favourites');
    }
};
