<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('deposit_requests', function (Blueprint $table) {
            $table->bigIncrements('id')->comment('Deposit request id');
            $table->string('request_id');
            $table->bigInteger('agency_id')->comment('Agency id');
            $table->bigInteger('user_id')->comment('User id');
            $table->double('amount', 9, 2)->comment('Amount');
            $table->date('deposit_date')->comment('Deposit date');
            $table->integer('core_payment_type_id')->comment('Core payment type id');
            $table->string('reference_no')->nullable()->comment('Reference no');
            $table->integer('core_bank_id')->nullable()->comment('Beneficiary bank detail of manager');
            $table->string('account_number')->nullable()->comment('Account Number');
            $table->string('name_in_account')->nullable()->comment('name as per account');
            $table->string('bank_name')->nullable()->comment('Bank name');
            $table->string('bank_branch')->nullable()->comment('Bank branch');
            $table->string('card_no')->nullable()->comment('cheque number');
            $table->date('cheque_issue_date')->nullable()->comment('cheque issue date');
            $table->string('remarks')->comment('Remarks');
            $table->set('status', ['open', 'closed', 'decline'])->default('open')->comment('status');
            $table->string('document')->nullable()->comment('scanned document copy');
            $table->string('decline_reason')->nullable()->comment('decline reason');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('deposit_requests');
    }
};
