<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers_traveller', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->char('customer_id', 36)->nullable()->index('customers_traveller_customer_id_foreign')->comment('reference id key of customer table');
            $table->char('booking_id', 36)->nullable();
            $table->string('traveller_id')->nullable();
            $table->string('traveler_type')->nullable();
            $table->string('title')->nullable();
            $table->string('first_name')->nullable();
            $table->string('second_name')->nullable();
            $table->string('last_name')->nullable();
            $table->date('date_of_birth')->nullable();
            $table->string('birth_place')->nullable();
            $table->string('gender')->nullable();
            $table->string('relationship')->nullable();
            $table->string('email')->nullable();
            $table->string('phone')->nullable();
            $table->string('address')->nullable();
            $table->string('passport_number')->nullable();
            $table->char('passport_nationality', 36)->nullable();
            $table->char('passport_issued_country', 36)->nullable();
            $table->string('national_id')->nullable();
            $table->char('national_id_nationality', 36)->nullable();
            $table->char('national_id_issued_country', 36)->nullable();
            $table->date('national_id_expiry_date')->nullable();
            $table->date('national_id_date_of_birth')->nullable();
            $table->string('iqama_id')->nullable();
            $table->char('iqama_id_nationality', 36)->nullable();
            $table->date('iqama_id_expire_date')->nullable();
            $table->string('frequently_flyer_airline_name')->nullable();
            $table->string('frequently_flyer_programme')->nullable();
            $table->string('frequently_flyer_number')->nullable();
            $table->char('nationality_id', 36)->nullable()->index('customers_traveller_nationality_id_foreign')->comment('reference id key of country table');
            $table->enum('id_type', ['passport', 'national_id'])->nullable();
            $table->string('id_number')->nullable();
            $table->date('issue_date')->nullable();
            $table->date('expire_date')->nullable();
            $table->char('country_id', 36)->nullable()->index('customers_traveller_country_id_foreign')->comment('reference id key of country table');
            $table->enum('status', ['active', 'inactive'])->nullable();
            $table->string('document')->nullable();
            $table->text('additional_details')->nullable();
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers_traveller');
    }
};
