<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customers', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->enum('title', ['mr', 'mrs', 'miss'])->nullable();
            $table->string('email')->nullable()->comment('customer unique email');
            $table->string('alternative_email')->nullable();
            $table->string('password')->nullable();
            $table->integer('agency_id')->default(0)->comment('customer agency id');
            $table->string('first_name')->nullable()->comment('customer first name');
            $table->string('last_name')->nullable()->comment('customer last name');
            $table->string('mobile_code');
            $table->string('mobile')->nullable()->comment('customer phone number');
            $table->date('date_of_birth')->nullable()->comment('customer date of birth');
            $table->enum('gender', ['male', 'female'])->nullable();
            $table->date('issue_date')->nullable();
            $table->string('emergency_contact_code');
            $table->string('emergency_contact_no')->nullable();
            $table->string('emergency_contact_title')->nullable();
            $table->string('emergency_contact_name')->nullable();
            $table->enum('marital_status', ['married', 'single', 'other'])->nullable();
            $table->date('marriage_aniversary_date')->nullable();
            $table->string('profile_photo')->nullable()->comment('customer profile photo');
            $table->tinyInteger('latest_deals')->default(0);
            $table->string('signup_with', 50)->nullable();
            $table->string('google_id')->nullable()->comment('customer google profile id');
            $table->string('facebook_id')->nullable()->comment('customer facebook profile id');
            $table->string('instagram_id')->nullable()->comment('customer instagram profile id');
            $table->string('twitter_id')->nullable()->comment('customer twitter profile id');
            $table->string('apple_id')->nullable()->comment('customer apple profile id');
            $table->string('user_currency')->nullable()->default('SAR');
            $table->string('user_language')->nullable()->default('en');
            $table->boolean('is_email_verified')->default(false);
            $table->boolean('is_mobile_verified')->default(false);
            $table->string('favorite_hotels')->nullable();
            $table->tinyInteger('show_supplier_name')->default(0);
            $table->text('deleted_reason')->nullable();
            $table->set('status', ['active', 'inactive', 'terminated', 'deleted'])->default('active');
            $table->timestamps();
            $table->softDeletes();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customers');
    }
};
