<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_otp_attempts', function (Blueprint $table) {
            $table->bigIncrements('id');
            $table->string('host');
            $table->string('username');
            $table->dateTime('attempt_at');
            $table->dateTime('next_login_available_at')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_otp_attempts');
    }
};
