<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_login_tokens', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('customer_id');
            $table->string('token')->unique();
            $table->timestamp('expires_at')->useCurrentOnUpdate()->useCurrent();
            $table->boolean('used')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_login_tokens');
    }
};
