<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_login_otps', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('phone_code');
            $table->string('mobile');
            $table->bigInteger('otp');
            $table->string('expired_at');
            $table->tinyInteger('is_verified')->default(0);
            $table->text('token');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_login_otps');
    }
};
