<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('customer_device_ids', function (Blueprint $table) {
            $table->char('id', 36)->primary();
            $table->string('customer_id')->default('Guest');
            $table->longText('device_id')->nullable();
            $table->string('mobile_code');
            $table->string('mobile_no');
            $table->tinyInteger('is_verified')->default(0);
            $table->string('search_from', 50);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('customer_device_ids');
    }
};
