<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('coupon_applicable_customer', function (Blueprint $table) {
            $table->unsignedBigInteger('id');
            $table->char('customer_id', 36)->nullable();
            $table->unsignedBigInteger('agency_id')->nullable()->comment('reference id key of agencies table');
            $table->char('coupon_id', 36);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('coupon_applicable_customer');
    }
};
